#include "ProjectDialog.h"

#define Inherited ProjectDialogData

ProjectDialog::ProjectDialog
(
	QWidget* parent,
	const char* name
)
    :
    Inherited( parent, name )
{
  connect( itsOKButton, 
           SIGNAL(clicked()), 
           SLOT(accept()) );
  connect( itsCancelButton, 
           SIGNAL(clicked()), 
           SLOT(reject()) );
}


ProjectDialog::~ProjectDialog()
{
}

QString ProjectDialog::GetName()  const
{
  return itsName->text();
}

void ProjectDialog::SetName( const QString &name )
{
  itsName->setText( name );
}

