#include <qlayout.h>

#include "layout/BoxWidget.h"

#include "widget/DlgWidget.h"

#include "GuiTools.h"
#include "WidgetLayout.h"

#define Inherited LayoutItem

BoxWidget::BoxWidget
(
    QWidget*		parent,
    DlgWidget*		widget,
    WidgetLayout*	layout,
    int			stretch,
    int			alignment
)
    :
    Inherited( layout ),
    itsWidget( widget ),
    itsParent( parent ),
    itsStretch( stretch ),
    itsAlignment( alignment )
{
    // NULL may be used for the widget, if this is a 'dummy' box widget
    // used for defaults
    if( itsWidget )
    {
	itsWidget->SetInLayout( itsParent );
    }
}


BoxWidget::~BoxWidget()
{
    if( itsWidget )
    {
	itsWidget->RemoveFromLayout();
    }
}


void BoxWidget::AddToLayout
(
    QBoxLayout*	layout
)
{
    layout->addWidget( itsWidget->GetWidget(), itsStretch, itsAlignment );
}


LayoutItem* BoxWidget::FindLayoutItem
(
    QWidget*	widget
) const
{
    return (widget == itsWidget->GetWidget()) ? this : (LayoutItem*)NULL;
}


void BoxWidget::SaveContents( QTextStream&	stream,
			      QString		id ) const
{
    stream << GetItemName() << "-" << id << "{\n";

    stream << "\t\tWidget {" << itsWidget->GetWidgetName() << "}\n";
    stream << "\t\tStretch {" << itsStretch << "}\n";
    stream << "\t\tAlignment {" << itsAlignment << "}\n";
    
    stream << "}\n";
}


bool BoxWidget::RestoreKeyValue( const QString&	key,
				 const QString&	value )
{
    bool rc = TRUE;
    
    if( key == "Widget" )
    {
	itsWidget = (DlgWidget*)itsWidgetLayout->GetWidget( value );
	
	if( itsWidget )
	{
	    itsWidget->SetInLayout( itsParent );
	}
	else
	{
	    rc = FALSE;
	}
    }
    else if( key == "Stretch" )
    {
	itsStretch = value.toInt();
    }
    else if( key == "Alignment" )
    {
	itsAlignment = value.toInt();
    }
    else
    {
	rc = FALSE;
    }
    
    return rc;
}


void BoxWidget::GenerateSource( QTextStream&	stream,
				const QString&	layoutVarName,
				const QString&	/*layoutId*/ ) const
{
    stream << '\t' << layoutVarName << "->addWidget( " << 
	itsWidget->GetGeneratedVarName() << ", " << itsStretch << ", " <<
	itsAlignment << " );\n";
}


QString BoxWidget::GetItemName( void ) const
{
    return ItemName();
}


QRect BoxWidget::GetGlobalGeometry( void ) const
{
    return GuiTools::GetGlobalGeometry( itsWidget->GetWidget() );
}

