#ifndef ColorFrame_included
#define ColorFrame_included

#include <qframe.h>
#include <qpushbt.h>
#include <qlabel.h>

const int PredefinedColors = 19;

class ColorButton : public QPushButton
{
  Q_OBJECT
public:
  ColorButton( QWidget *, const QColor & );

private:
  virtual void mousePressEvent( QMouseEvent * );

signals:
  void ColorClicked( int, QWidget * ); 

};

class EditButton : public QPushButton
{
  Q_OBJECT
public:
  EditButton( const QString &, QWidget * );

private:
  virtual void mousePressEvent( QMouseEvent * );

signals:
  void Clicked( int ); 

};

class ColorFrame : public QFrame
{
  Q_OBJECT
public:
  ColorFrame( QWidget *parent );
  
  void SetLeftColor( const QColor & );
  void SetRightColor( const QColor & );

signals:
  void ColorChanged( int, const QColor & );

private slots:
  void ColorClicked( int, QWidget * );
  void EditColor( int );

private: // Attributes
  QPushButton *editButton;
  QWidget *lastColorClicked;
  QLabel *leftColor, *rightColor;
};

inline void ColorFrame::SetLeftColor( const QColor &c )
{
  leftColor->setBackgroundColor( c );
}

inline void ColorFrame::SetRightColor( const QColor &c )
{
  rightColor->setBackgroundColor( c );
}

#endif
