#include <qgrpbox.h>

#include "GroupBoxPage.h"

#include "widget/DlgWidget.h"

#define Inherited GroupBoxPageData

GroupBoxPage::GroupBoxPage
(
    DlgWidget* widget,
    QWidget* parent,
    const char* name
)
    :
    Inherited( parent, name )
{
    QGroupBox* box = (QGroupBox*)widget->GetWidget();
    
    itsTitle->setText( box->title() );
    
    switch( box->alignment() & (AlignLeft | AlignRight | AlignHCenter) )
    {
	case AlignLeft:
	default:
	{
	    isTitleLeft->setChecked( TRUE );
	    break;
	}
	case AlignHCenter:
	{
	    isTitleCenter->setChecked( TRUE );
	    break;
	}
	case AlignRight:
	{
	    isTitleRight->setChecked( TRUE );
	    break;
	}
    }
}


GroupBoxPage::~GroupBoxPage()
{
}


void GroupBoxPage::Apply( DlgWidget*	widget )
{
    QGroupBox* box = (QGroupBox*)widget->GetWidget();
    
    box->setTitle( itsTitle->text() );
    
    int alignment = AlignLeft;	// default

    if( isTitleCenter->isChecked() )
    {
	alignment = AlignHCenter;
    }
    else if( isTitleRight->isChecked() )
    {
	alignment = AlignRight;
    }

    box->setAlignment( alignment );
}
