#include "widget/MultiLineEdit.h"

#define Inherited QMultiLineEdit

MultiLineEdit::MultiLineEdit
(
    QWidget*		widget,
    const char*		name
)
    :
    Inherited( widget, name )
{
}


void MultiLineEdit::mousePressEvent
(
    QMouseEvent*	event
)
{
    emit MousePress( this, event );	
    //Inherited::mousePressEvent( event );
    
}


void MultiLineEdit::mouseDoubleClickEvent( QMouseEvent*	event )
{
    emit MouseDoubleClick( this, event );
}


void MultiLineEdit::mouseMoveEvent
(
    QMouseEvent*	event
)
{
    emit MouseMove( this, event );
    //Inherited::mouseMoveEvent( event );
    
}


void MultiLineEdit::mouseReleaseEvent
(
    QMouseEvent*	 //event
)
{
    emit MouseRelease();
    //Inherited::mouseReleaseEvent( event );
    
}


void MultiLineEdit::paintEvent
(
    QPaintEvent*	event
)
{
    Inherited::paintEvent( event );
    
    emit Paint( this );
}


void MultiLineEdit::resizeEvent
(
    QResizeEvent*	event
)
{
    Inherited::resizeEvent( event );
    
    emit Resize( this, event );
}


void MultiLineEdit::moveEvent
(
    QMoveEvent*	event
)
{
    Inherited::moveEvent( event );
    
    emit Move( this, event );
}





