#include "figure.hh"
#include "pencil.hh"

TFigGroup::~TFigGroup()
{
	TFigureVector::iterator p,e;
	p = figures.begin();
	e = figures.end();
	while(p!=e) {
		delete *p;
		p++;
	} 
}

void 
TFigGroup::CalcSize()
{
	double x2, y2, ix2, iy2;
	x=y=0;
	w=h=1;
	TFigureVector::iterator p,e;
	p = figures.begin();
	e = figures.end();
	if (p==e)
		return;
	x=(*p)->x;
	y=(*p)->y;
	x2=x+(*p)->w;
	y2=y+(*p)->h;
	p++;
	while(p!=e) {
		TFigure *g = *p;
		if (g->x < x)
			x = g->x;
		if (g->y < y)
			y = g->y;
		ix2 = g->x + g->w;
		iy2 = g->y + g->h;
		if (x2 < ix2)
			x2=ix2;
		if (y2 < iy2)
			y2=iy2;
		p++;
	}
	w = x2 - x;
	h = y2 - y;
	
	x+=dx;
	y+=dy;
}

void 
TFigGroup::paint(TPencil &pen, bool)
{
	TFigureVector::iterator p,e;
	p = figures.begin();
	e = figures.end();
	pen.Translate(dx,dy);
	while(p!=e) {
		(*p)->paint(pen, false);
		p++;
	}
	pen.Translate(-dx,-dy);
//	pen.SetColor(255,0,0);
//	pen.DrawRectangle(x,y,w,h);
}

double
TFigGroup::distance(double mx, double my)
{
//	cout << "group distance: mouse at     " << mx <<","<< my << endl;
//	cout << "                translate at " << mx-dx <<","<< my-dy << endl;
	TFigureVector::iterator p,e;
	p = figures.begin();
	e = figures.end();
	if (p==e)
		return OUT_OF_RANGE;
	double d = (*p)->distance(mx-dx,my-dy);
	p++;
	while(p!=e) {
		TFigure *g = *p;
//		cout << "get distance to x:" << g->x << " y:" << g->y << " w:" << g->w << " h:" << g->h << endl;
		double td = (*p)->distance(mx-dx,my-dy);
		if (td<d)
			d=td;
		p++;
	}
//cout << "group distance: " << d << endl;
	return d;
}

void
TFigGroup::translate(double dx, double dy)
{
	x+=dx;
	y+=dy;
	this->dx+=dx;
	this->dy+=dy;
}

void 
TFigGroup::store(TOutBinStream &file, ulong version)
{
	file.WriteSWord(dx);
	file.WriteSWord(dy);
	file.WriteDWord(figures.size());
	TFigureVector::iterator p,e;
	p = figures.begin();
	e = figures.end();
	while(p!=e) {
		TFigure::Store(file, *p);
		p++;
	} 
}

void 
TFigGroup::restore(TInBinStream &file, ulong version)
{
	dx = file.ReadSWord();
	dy = file.ReadSWord();
	unsigned count = file.ReadDWord();
	for(unsigned i=0; i<count; i++) {
		TFigure *g = TFigure::Restore(file);
		figures.push_back(g);
	}
	CalcSize();
//	cout << "x:" << x << " y:" << y << " w:" << w << " h:" << h << endl;
}
