#include <toad/toad.hh>
#include <toad/combobox.hh>
#include <toad/listbox.hh>

class TMyWindow: public TWindow
{
		typedef TWindow super;
	public:
		TMyWindow(TWindow* p, const string& t);
};

int ToadMain()
{
	return TMyWindow(NULL,"ComboBox eXperiment").Run();
}

class TStringAdapter:
	public TLBAdapter
{
	public:
		unsigned ItemHeight();
		void PrintItem(int x, int y, unsigned item, TPen &pen);
		virtual const string& Item(unsigned) = 0;
};

unsigned TStringAdapter::ItemHeight()
{
	return TOADBase::DefaultFont().Height();
}

void TStringAdapter::PrintItem(int x, int y, unsigned item, TPen &pen)
{
	if (item<ItemCount())
		pen.DrawString(x, y, Item(item));
}

class TVectorStringAdapter:
	public TStringAdapter
{
		vector<string> *data;
	public:
		TVectorStringAdapter(vector<string> *d):data(d){}
		unsigned ItemCount();
		const string& Item(unsigned);
};

unsigned TVectorStringAdapter::ItemCount()
{
	if (!data) return 0;
	return data->size();
}

const string& TVectorStringAdapter::Item(unsigned n)
{
	return (*data)[n];
}

TMyWindow::TMyWindow(TWindow* p, const string& t):
	super(p, t)
{
	TListBox *lb1;
	lb1 = new TListBox(this, "listbox1", (TLBAdapter*)0);
	lb1->SetShape(5,5,310,190);
	
	static vector<string> data;
	data.push_back("The Spider");
	data.push_back("The Toad");
	data.push_back("The Cauldron");
	lb1->SetAdapter(new TVectorStringAdapter(&data));
	
#if 0
	TComboBox *cb1;
	cb1 = new TComboBox(this, "combobox1", (TLBAdapter*)0);
	cb->SetShape(5,5,200,TSIZE_PREVIOUS);
#endif
}
