/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for X-Windows
 * Copyright (C) 1996-98 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,   
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public 
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef TElement
#define TElement TElement

#include <toad/toad.hh>
#include <toad/pointer.hh>
#include <vector>
#include <string>

class TState;
class TStateInit;

struct TElement
	:public TSmartObject
{
		TElement();
		virtual ~TElement() {}
		int width;				// must be set to final value after init stage 1
		unsigned size;		// must be set to final value after init stage 1
											// the default value is `1' and tells you how
											// many elements this element measures
		bool space:1;			// must be set to final value after init stage 1
											// in some situations this flag will also be set
											// by the parser
		bool nl_before:1;	// new line before element, default=false and
											// must be set after init()
		bool nl_width:1;	// new line when line exceeds right border, default=true
											// and must be set after init()
		bool nl_after:1;	// new line after element  (default=true) 
											// abd must be set after init()
		virtual void addParam(const string& lvalue, const string& rvalue) { }
		virtual void init(TStateInit& state, int stage) { }
		virtual void paint(TPen& pen, TState& state) { }
		virtual void afterPaint(TState& state) { }

		static int GetPercent(const string &s);
		static int GetInteger(const string &s, int default_value=0);
		enum EAlign { ALIGN_NONE, ALIGN_LEFT, ALIGN_MIDDLE, ALIGN_RIGHT };
		static EAlign GetAlign(const string &s);
		
		static bool GetColor(const string &s, TRGB&);	
};

typedef GSmartPointer<TElement> PElement;

class TElementVector
	:public vector<PElement>
{
		typedef vector<PElement> super;
	public:
		void erase() {
			cout << "eraseing " << super::size() << " TElements" << endl;
			super::erase(begin(), end());
		}
};

struct TEWord:
	public TElement
{
	string word;

	TEWord(const string& s);
	void init(TStateInit& state, int stage);
	void paint(TPen& pen, TState& state);
};

struct TEBreak:
	public TElement
{
	TEBreak();
};

struct TEParagraph:
	public TElement
{
	void init(TStateInit& state, int stage);
};

struct TEPreformatedBgn:
	public TElement
{
	void init(TStateInit& state, int stage);
	void afterPaint(TState& state);
}; 

struct TEPreformatedEnd:
	public TElement
{
	void init(TStateInit& state, int stage);
	void afterPaint(TState& state);
}; 
	
struct TEHeading1Bgn:
	public TElement
{
	void init(TStateInit& state, int stage);
	void afterPaint(TState& state);
}; 

struct TEHeading2Bgn:
	public TEHeading1Bgn
{
	void afterPaint(TState& state);
};

struct TEHeading3Bgn:
	public TEHeading1Bgn
{
	void afterPaint(TState& state);
};

struct TEHeadingEnd:
	public TElement
{
	void init(TStateInit& state, int stage);
	void afterPaint(TState& state);
};

struct TEHorizontalRule:
	public TElement
{
	void init(TStateInit& state, int stage);
	void paint(TPen& pen, TState& state);
};

struct TEUnorderedListBgn:
	public TElement
{
	TEUnorderedListBgn();
	void afterPaint(TState& state);
};

struct TEUnorderedListEnd:
	public TElement
{
	TEUnorderedListEnd();
	void afterPaint(TState& state);
};

struct TEListItem:
	public TElement
{
	TEListItem();
	void paint(TPen& pen, TState& state);
};


struct TEAnchorBgn:
	public TElement
{
	string href;
	string name;
	void addParam(const string& lvalue, const string& rvalue);
	void afterPaint(TState& state);
};

struct TEAnchorEnd:
	public TElement
{
	void afterPaint(TState& state);
};

class TBitmap;

struct TEImage:
	public TElement
{
	int _w;
	int _h;
	string src;
	string alt;
	int border;
	TEImage();
	~TEImage();
	void addParam(const string& lvalue, const string& rvalue);
	void init(TStateInit& state, int stage);
	void paint(TPen& pen, TState& state);
	
	TBitmap *bitmap;
};
	
struct TETableBgn:
	public TElement
{
	int start_idx, end_idx;
	int height, width;				// table size in pixels
	int rows, cols;						// table size in fields
	int table_min_width;
	int table_max_width;
	EAlign align;
		
	int border;								// controls frame width around table
	int cellspacing;					// spacing between cells
	int cellpadding;					// spacing within cells to cell content
	int pwidth;								// width in percent (-1=none)
	int cwidth;								// const width (-1=none)

	struct TField;
	TField *field;
	
	struct TRow
	{
		int max_height;			// of all fields in a row
	};
	TRow *row;

	struct TCol
	{
		int min_width, max_width;			// of all fields in a column
		int width;
	};
	TCol *col;
		
	TETableBgn();
	~TETableBgn();
  void addParam(const string& lvalue, const string& rvalue);
  void init(TStateInit& state, int stage);
	void paint(TPen& pen, TState& state);
	void afterPaint(TState& state);
};

struct TETableEnd:
	public TElement
{
};

struct TETableRow:
	public TElement
{
};

struct TETableData:
	public TElement
{
	TETableData();
	void addParam(const string &lvalue, const string &rvalue);
	int cwidth;
	TRGB bgcolor;
	bool bgcolor_valid;
};

struct TETableHead:
	public TETableData
{
};

#endif
