#include <toad/toad.hh>
#include <toad/simpletimer.hh>
#include <iostream.h>

class TMyWindow:
	public TWindow
{
	public:
		TMyWindow(TWindow* p, const string& t);
};

class TMyTimer:
	public TSimpleTimer
{
		string _name;
	public:
		TMyTimer(const string name, int ms) {
			_name = name;
			StartTimer(0, ms);
		}
		void tick() {
			cout << "tick: " << _name << endl;
		}
};

int ToadMain()
{
	return TMyWindow(NULL,"Timer").Run();
}

TMyWindow::TMyWindow(TWindow* p, const string& t)
	:TWindow(p, t)
{
	new TMyTimer("timer 1s", 1000000);
	new TMyTimer("timer 0,5s", 500000);
}
