/*
	stupid, 3rd try -- another stupid c++ to html generator
	
	Copyright (C) 1998,99,00 The Wizards of Zilog

	Written by The Ratface        <watchman@mark13.de>
	       and The Wizard Himself <mhopf@mark13.de>

  Further hacking should be done with some C64 tunes from Rob Hubbard and
  Martin Galway or N64 tunes playing in the background; SIDs, MIDs, MP3s,
  CDs or tapes will do fine.

	This program is a huge bunch of trash; you should redistribute it,
	especially to your enimies and/or modify it or write a better one under
	the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License, or (at your option)
	any later version.
	
	This program is distributed in the hope that it might be useful or give
	you a laugh or two, but WITHOUT ANY WARRANTY; without even the implied
	warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details and ask your laywer why life
	became so damn complicated these days.
	
	You should have received a copy of the GNU General Public License along
	with this junk; if not, have a look at all those thousand COPYING files
	on your hard disk or write to the guys at the Free Software Foundation,
	Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA and while
	doing this, include some cash.
*/

/*
	bugs we dislike (all others bugs are features)
	- `constructor(...) : super(...)'
	  fails after the colon
	- can't parse function pointers, e.g.
	  void (*         signal(int signum, void (*handler)(int))  )(int)
	  <=>
	  (void (*)(int)) signal(int signum, void (*handler)(int))
	- enumerations are missing
	- the line "PropMotifWmHints : bVisible = true" is complete nonsense
*/

#include <cstdio>
#include <iostream>
#include <fstream>
#include <string>
#include <map>
#include <vector>
#include <stack>
#include <string.h>
#include <ctype.h>
#include <unistd.h>
#include <dirent.h>
#include <sys/stat.h>

#include "utility.hh"

// output string constants
#define DB_S(A)

// output last line
#define DB_LL(A)

// various debug messages
#define DBM(A)

string current_file;	// the current filename
string current_cppfile;
string source;				// the contents of the file after `cpp'

bool test(const char *&sptr, const char *t)
{
	unsigned l = strlen(t);
	if (strncmp(sptr, t, l) == 0) {
		if (!isalnum(*(sptr+l)) && *(sptr+l)!='_') {
			sptr+=l-1;
			return true;
		}
	}
	return false;
}

void get_identifier(const char *&sptr, string &cn)
{
	const char *p1=sptr;
	while(isalnum(*p1) || *p1=='_')
		p1++;
	cn.assign(sptr, p1-sptr);
	cn = trim(cn);
	sptr=p1;
}

void skip_ws(const char *&sptr)
{
	while(isspace(*sptr))
		sptr++;
}

// fails when strings or comments with `<' or `>' are placed in the
// template argument
void skip_template_arg(const char *&sptr)
{
	if (*sptr!='<') {
		return;
	}
	unsigned c=0;
	while(true) {
		switch(*sptr) {
			case '<':
				c++;
				break;
			case '>':
				c--;
				if (c==0) {
					sptr++;
					return;
				}
				break;
			case '\"':
				DBM(cout << "WARNING: string constant in template argument\n";)
				break;
			case '/':
				DBM(cout << "WARNING: there might be a comment in the template argument\n";)
				break;
		}
		sptr++;
	}
}

void global_found_function();
void class_declaration(const string &classname, const string &file, bool templ);
void class_found_super(const string &classname, const string &super);
void class_function_comment(const string &classname, const string &function, const string &comment);

void output_text();

void skip(const char *&sptr)
{
	if (isalnum(*sptr) || *sptr=='_') {
		while(isalnum(*sptr) || *sptr=='_')
			sptr++;
	} else {
		sptr++;
	}
}

enum EState {
	NONE, 
	CLASSNAME, CLASSNAME_CONTINUES, CLASS_EXPECT_BODY, CLASS_EXPECT_SUPER,
	TEMPLATE,
	FUNCTION,
	TYPEDEF,
	ENUM,
	SKIP_COLON
};

stack<EState> state;

typedef vector<string> TStringVec;

// class level:
//   0: global context
//   1: class context
//   2: class-in-a-class context
//   ...

enum EAccess { PUBLIC, PROTECTED, PRIVATE };

// structure for class during parse
// `access' relates to the previous class!!!
struct TClassInfo
{
	TClassInfo(const string& n, EAccess a) {
		name = n;
		access = a;
	}
	TClassInfo(const TClassInfo &c) {
		name = c.name;
		access = c.access;
	}
	string name;
	EAccess access;
};

typedef vector<TClassInfo> TClassInfoVec;
TClassInfoVec classname;

// strings collected for function names
TStringVec function_name;

unsigned af_cnt=0;
bool af_operator=false;		// function name started with `operator' keyword
bool af_skip=false;
bool af_was_function=false;

void clear_function() {
	if (state.empty()) {
		cerr << "UPS, CLEAR FUNCTION BUT STATE STACK IS EMPTY" << endl;
		cerr << "file: " << current_cppfile << endl;
		cerr << "source:" << endl << source << endl;
		exit(1);
		return;
	}
	if (state.top()!=FUNCTION) {
		function_name.erase(function_name.begin(), function_name.end());
		af_cnt=0;
		af_operator=false;
		af_skip=false;
		af_was_function=false;
	}
}

void check_function_buffer();

void add_function(const string &s) {
	// check for non-functions, this might fail
	if (state.top()==FUNCTION) {
		if (s[0]=='*') {
			af_skip=true;
		}
	}

	if (af_cnt==0) {
		if (state.top()!=FUNCTION && s=="operator")
			af_operator=true;
		function_name.push_back(s);
	}	else {
		if(function_name.size()==0)
			function_name.push_back("");
		function_name.back()+=s;
	}
}

void add_function(char c) {
	switch(c) {
		case '<':
			if (!af_operator)
				af_cnt++;
			break;
		case '>':
			if (!af_operator)
				af_cnt--;
			break;
		default:
			if (af_cnt==0 && !af_operator)
				function_name.push_back("");
	}
	if (function_name.size()==0)
		function_name.push_back("");
	function_name.back()+=c;
}

void print_function()
{
	TStringVec::iterator p,e;
	p=function_name.begin();
	e=function_name.end();
	while(p!=e) {
		cout << "  " << *p << endl;
		p++;
	}
}

string ad_id;					// `//!<text>'
string ad_txt;				// `//.<text>'
EAccess crnt_access;	// current access (PUBLIC, PROTECTED, PRIVATE)

void parse_file(const char *filename)
{
//	cout << endl << endl << "parsing file " << filename << endl;
	current_cppfile = filename;
	source.erase();

	string cn;			// the name after the last `class' text
	bool bTemplate;	// next class is a template
	
	string cmd = "cpp -DHAVE_PNG -DHAVE_JPEGLIB -C -I../../include ";
	cmd += filename;
	
	FILE *cpp = popen(cmd.c_str(), "r");
	char buffer[1024];
	unsigned total = 0;
	while(!feof(cpp)) {
		int n = fread(buffer, 1, 1024, cpp);
		total+=n;
		source.append(buffer, n);
	}
	source+="                ";	// avoid length checks
//	cout << "read " << total << " bytes\n";
//	cout << "source:" << endl << source << endl;

	crnt_access=PUBLIC;

	function_name.clear();
	classname.clear();
	af_cnt=0;
	af_operator=false;
	af_skip=false;
	af_was_function=false;

	ad_id.erase();
	ad_txt.erase();

	while(!state.empty())
		state.pop();
	state.push(NONE);
	
	// number of open `{' braces
	// increments on `{' and decrements on `}'
	unsigned brace_counter=0;

	EAccess next_access;					// set when running into `struct' or `class'
	
	unsigned tbrace_counter=0;		// during typedef
	unsigned fbrace_counter=0;		// during function
	string param;									// during function
	
	const char *p1,*p2;

	const char *start = source.c_str();
	const char *end=start+total;
	const char *sptr=start;

	DB_LL(const char *last=start;)

	bTemplate = false;

	while(sptr<=end) {
		DB_LL({string s;s.assign(last,sptr-last);cout<<"last: "<<s<<endl;last=sptr;})
		while(isspace(*sptr))
			sptr++;
		switch(*sptr) {
			case '#':	// filename & line number information
				// cout << "preprocessor" << endl;
				p1=strchr(sptr,'\"')+1;
				p2=strchr(p1, '\"');
				current_file.assign(p1,p2-p1);
				sptr=strchr(sptr, '\n');
				// cout << "file: " << file << endl;
				sptr++;
				clear_function();
				continue;

			case '\"': // string constant
				DB_S(cout << "skipping string: [";)
				sptr++;
				while(*sptr!='\"') {
					DB_S(cout << *sptr;)
					if (*sptr=='\\') {
						sptr++;
						DB_S(cout << *sptr;)
					}
					sptr++;
				}
				DB_S(cout << "]" << endl;)
				sptr++;
				continue;

			case '/':
				sptr++;
				switch(*sptr) {
					case '*':	// C style comment
						sptr++;
						while(true) {
							if (*sptr=='*') {
								sptr++;
								if (*sptr=='/')
									break;
							}
							sptr++;
						}
						sptr++;
						clear_function();
						continue;
					case '/': // C++ style comment
						// cout << "c++ style" << endl;
						sptr++;
						p1=strchr(sptr,'\n');
						switch(*sptr) {
							case '!':
								if (!ad_id.empty())
									class_function_comment(ad_id, "", ad_txt);
								sptr++;
								skip_ws(sptr);
								get_identifier(sptr, ad_id);
								if (ad_id=="TAlterBitmap") {
									cout << "TAlterBitmap" << endl;
								} else if (ad_id=="TBitmap") {
									cout << "TBitmap" << endl;
								}
								ad_txt.erase();
								break;
							case '?':
								if (!ad_id.empty())
									class_function_comment(ad_id, "", ad_txt);
								ad_id.erase();
								ad_txt.erase();
								break;
							case '.':
								ad_txt.append(sptr+1, p1-sptr-1);
								ad_txt.append("\n");
								break;
						}
						sptr=p1;
						clear_function();
						continue;
				}
				break;
		}

		while(isspace(*sptr))
			sptr++;

		switch(state.top()) {
			case NONE:
				if (test(sptr, "class")) {
					DBM(cout << "KEYWORD class" << endl;)
					next_access = PRIVATE;
					state.push(CLASSNAME);
				} else if (test(sptr, "struct")) {
					next_access = PUBLIC;
					state.push(CLASSNAME);
				} else if (test(sptr, "template")) {
					state.push(TEMPLATE);
				} else if (test(sptr, "typedef")) {
					state.push(TYPEDEF);
				} else if (test(sptr, "enum")) {
					state.push(ENUM);
				} else if (test(sptr, "public")) {
					crnt_access = PUBLIC;
					state.push(SKIP_COLON);
				}	else if (test(sptr, "protected")) {
					crnt_access = PROTECTED;
					state.push(SKIP_COLON);
				}	else if (test(sptr, "private")) {
					crnt_access = PRIVATE;
					state.push(SKIP_COLON);
				}	else {
					// clear `bTemplate' because the next one isn't a class
					bTemplate = false;
					{
						string s;
						get_identifier(sptr, s);
						if (s.size()>0) {
							if (brace_counter==classname.size())
								add_function(s);
							sptr--;
						} else if (!isspace(*sptr)) 
						{
							switch(*sptr) {
								case '{':
									brace_counter++;
									break;
								case '}':
									brace_counter--;
									if (brace_counter<classname.size()) {
										DBM(cout << "LEAVING CLASS " << classname.back().name << endl;)
										crnt_access = classname.back().access;
										classname.pop_back();
										state.pop();
// cout << state.size() << endl;
										sptr++;
										continue;
									}
									break;
							}
							if (brace_counter==classname.size()) {
								switch(*sptr) {
									case '{':
										brace_counter++;
									case ';':
										check_function_buffer();
									case '}':
										clear_function();
										break;
									case '(':
										DBM(cout << "FUNCTION " << function_name.back() << endl;)
										state.push(FUNCTION);
										fbrace_counter=1;
										af_operator=false;
										add_function("(");
										param.erase();
										break;
									default:
										add_function(*sptr);
								}
							}
							sptr++;
							continue;
						}
					}
				}
				skip(sptr);
				continue;

			case FUNCTION: {
				switch(*sptr) {
					case '(':
					case '<':
						fbrace_counter++;
						param+='(';
						break;
					case ')':
					case '>':
						fbrace_counter--;
						if (fbrace_counter>0) {
							param+=')';
							// check for `(0)' or `"((void *)0)' and convert it back to `NULL'
							if (param.size()>=3 && 
								  param.compare("(0)", param.size()-3)==0) 
							{
								param.replace(param.size()-3, 3, "NULL", 4);
							} else if (param.size()>=11 && 
												 param.compare("((void *)0)", param.size()-11)==0) 
							{
								param.replace(param.size()-11, 11, "NULL", 4);
							}
						} else {
							add_function(param);
							add_function(')');
						}
						break;
					case ',':
						if (fbrace_counter==1) {
							add_function(param);
							add_function(',');
							param.erase();
						} else {
							param+=',';
						}
						break;
					default:
						param+=*sptr;
				}
				if (param.size()!=0 && isspace(*(sptr+1)) )
					param+=' ';

				if (fbrace_counter==0) {
					state.pop();
					if (!af_skip) {
						global_found_function();
						af_skip=true;
					}
				}
				} break;

			case CLASSNAME: {
				get_identifier(sptr, cn);
				DBM(cout << "CLASSNAME: " << cn << endl;)
				if (cn.size()==0) {
					state.pop();	// this might be a `typedef' construct
				} else {
					state.pop();
					state.push(CLASS_EXPECT_BODY);
				}} continue;

			case CLASSNAME_CONTINUES: {
				string s;
				get_identifier(sptr, s);
				cn+=s;
				DBM(cout << "CLASSNAME CONTINUES TO: " << cn << endl;)
				state.pop();
				} continue;

			case CLASS_EXPECT_BODY:
				switch(*sptr) {
					case ':':
						if (*(sptr+1)==':') {
							cn+="::";
							state.push(CLASSNAME_CONTINUES);
							sptr++;
							DBM(cout << "CLASSNAME CONTINUES" << endl;)
							break;
						}
						DBM(cout << "FOUND : AFTER CLASSNAME, SUPER CLASSES TO FOLLOW\n";)
						class_declaration(cn, current_file, bTemplate);
						state.pop();
						state.push(CLASS_EXPECT_SUPER);
						break;
					case '{':
						class_declaration(cn, current_file, bTemplate);
						brace_counter++;
						state.pop();
						state.push(NONE);
						classname.push_back(TClassInfo(cn, crnt_access));
						crnt_access = next_access;
						DBM(cout << "ENTERING CLASS " << cn << endl;)
						break;
					case '<':
						if (!bTemplate) {
							// special template definition
							bTemplate=true;
						}
						while(*sptr!='>')
							sptr++;
						sptr++;
						continue;
					default:
						state.pop();
				} 
				bTemplate = false;
				break;

			case CLASS_EXPECT_SUPER:
				switch(*sptr) {
					case '{':
						brace_counter++;
						state.pop();
						state.push(NONE);
						classname.push_back(TClassInfo(cn, crnt_access));
						crnt_access = next_access;
						DBM(cout << "ENTERING CLASS " << cn << endl;)
						break;
					case ';':
						cerr << "ERROR: i didn't expect a `;' in the list of superclasses for class\n"
										"       " << cn << endl;
						state.pop();
						break;
					default: {
							string s;
							get_identifier(sptr, s);
							if (s.size()==0) {
								switch(*sptr) {
									case ',':
										sptr++;
										break;
									default:
										cerr << "ERROR: unknown operator `"<<*sptr<<"' in super class list\n";
										exit(1);
								}
							} else if (s!="public" && s!="protected" && s!="private" && s!="virtual") {
								class_found_super(cn, s);
							}
							skip_ws(sptr);
							skip_template_arg(sptr);
							continue;
						}
				}
				bTemplate = false;
				break;

			case TEMPLATE: {	// stupid trick to skip SOME templates
				while(*sptr!='>')
					sptr++;
				state.pop();
				bTemplate = true;
			} break;
			
			case TYPEDEF: {
				switch(*sptr) {
					case '{':
						tbrace_counter++;
						break;
					case '}':
						tbrace_counter--;
						break;
					case ';':
						if (tbrace_counter==0)
							state.pop();
				}
				sptr++;
				} continue;
			
			case ENUM: {
				static bool inside=false;
				static string typname;
				static string enumname;
				switch(*sptr) {
					case '{':
//						cout << "ENUM: " << typname << endl;
						inside=true;
						break;
					case ',':
//						cout << "  " << enumname << endl;
						enumname.erase();
						break;
					case '}':
//						cout << "  " << enumname << endl;
						add_function(typname);
						state.pop();
						enumname.erase();
						typname.erase();
						inside=false;
						break;
					default:
						if (inside) {
							enumname+=*sptr;
						} else {
							typname+=*sptr;
						}
				}
				break;
			}
			
			case SKIP_COLON:
				if (*sptr!=':') {
					cerr << "EXPECTED `:' got `" << *sptr << "'\n";
					string s;
					s.assign(sptr,100);
					cout << s << endl;
					exit(1);
				} else {
					state.pop();
				}
				break;
		}
		sptr++;
	}

	pclose(cpp);
}

struct TFunction
{
	TFunction() {
		has_header_comment = false;
	}
	string name;
	struct TIncarnation {
		TIncarnation(const string &fn, EAccess a) {
			fullname = fn;
			access = a;
		}
		TIncarnation(const TIncarnation &c) {
			fullname = c.fullname;
			access = c.access;
		}
		string fullname;
		EAccess access;
	};
	typedef vector<TIncarnation> TIncarnationVec;
	TIncarnationVec incarnation;
	string comment;
	bool has_header_comment;
};

typedef map<string,TFunction*> TFuncMap;

struct TAttribut
{
	string type;
	string name;
	EAccess access;
	string comment;
};

typedef map<string,TAttribut*> TAttrMap;

struct TClass
{
	string name;					// class name
	string file;					// declared in file
	bool is_template;			// true when this class is a generic class
	TStringVec super;			// names of the super classes
	TFuncMap func_map;		// functions defined in this class
	TAttrMap attr_map;		// attributes defined in this class
	string comment;				// a comment on what the class is doing
};

typedef map<string,TClass*> TClassMap;
TClassMap class_map;

TClass *make_class(const string &classname)
{
	TClassMap::iterator p = class_map.find(classname);
	if (p==class_map.end()) {
		DBM(cout << "CREATING CLASS " << classname << endl;)
		TClass *c = new TClass;
		c->name = classname;
		class_map[classname]=c;
		return c;
	}
	return (*p).second;
}

void class_declaration(const string &classname, const string &filename, bool t)
{
if (::classname.size()>0)	return;

	TClass *c = make_class(classname);
	if (c->file.size()!=0 && c->file!=filename) {
		cerr << "WARNING: class `" << classname << "' declared in different files\n";
		return;
	}
	c->is_template = t;
	c->file = filename;
}

void 
class_found_super(const string &classname, const string &super)
{
	if (::classname.size()>0)	
		return;
	TClass *c = make_class(classname);
	TStringVec::iterator p,e;
	p=c->super.begin();
	e=c->super.end();
	while(p!=e) {
		if ( *p==super )
			return;
		p++;
	}
	c->super.push_back(super);
}

void
class_found_attribute(TClass *c,
											const string &shortname,
											const string &typname,
											const string &fullname,
											EAccess access)
{
	TAttrMap::iterator pam=c->attr_map.find(shortname);
	if (pam==c->attr_map.end()) {
		TAttribut *a = new TAttribut;
		a->type = typname;
		a->name = fullname;
		a->access = access;
		c->attr_map[shortname]=a;
	}
}
											

void 
class_found_function(const string &classname, 
										 const string &function, 
										 const string &all, 
										 EAccess access)
{
	af_was_function=true;
	TClass *c = make_class(classname);
	TFuncMap::iterator pfm=c->func_map.find(function);
	TFunction *f;
	if (pfm==c->func_map.end()) {
		f = new TFunction;
		c->func_map[function]=f;
		f->name = function;
	} else {
		f = (*pfm).second;
	}
	TFunction::TIncarnationVec::iterator piv,e;
	piv = f->incarnation.begin();
	e = f->incarnation.end();
	while(piv!=e) {
		if ( (*piv).fullname == all )
			return;
		piv++;
	}
	f->incarnation.push_back(TFunction::TIncarnation(all, access));
}

void 
class_function_comment(const string &classname, const string &function, const string &comment)
{
	if (!ad_id.empty()) {
		TClass *c = make_class(ad_id);
		if (c->comment.size()!=0 && comment.size()!=0)
			c->comment+="<P>";
		c->comment+=comment;
#if 0
cout << "CLASS FUNCTION COMMENT" << endl;
cout << "comment: [" << comment << "]" << endl;
cout << "classname: [" << classname << "]" << endl;
cout << "function: [" << function << "]" << endl;
cout << "ad_id: [" << ad_id << "]" << endl;
#endif
		ad_id.erase();
		return;
	}

	TClass *c = make_class(classname);
	TFuncMap::iterator p=c->func_map.find(function);
	TFunction *f;
	if (p==c->func_map.end()) {
		f = new TFunction;
		c->func_map[function]=f;
		f->name = function;
	} else {
		f = (*p).second;
	}
	bool header = wildcard("*.hh" , current_file.c_str());
	if (header && f->has_header_comment)
		return;
	f->has_header_comment = header;
	if (f->comment.size()!=0 && comment.size()!=0)
		f->comment+="<P>";
	f->comment+=comment;
}

void 
global_found_function()
{
	// get the functions class name from the `function_name' buffer
	TStringVec::iterator p,e;

	p=function_name.begin();
	e=function_name.end();

	// get class name, or "::" if none
	string cn="::";
	while(p!=e) {
		if ( *p=="(" )
			break;
		if ( *p==":" && *(p+1)==":" ) {
			cn=*(p-1);
			function_name.erase(p-1,p+2);
			break;
		}
		p++;
	}

if(classname.size()==1 && cn=="::") {
	cn = classname[0].name;
} else if (classname.size()>1) {
	return;
} else if (classname.size()==1 && cn!="::") {
	return;
}

	// get function name
	// this fails when the name is `operator()'!!!
	string fn;
	p=function_name.begin();
	e=function_name.end();
	while(p!=e) {
		if ( *p=="(" ) {
			fn=*(p-1);
			break;
		}
		p++;
	}

// skip global <class>::<method> definitions, just add the comment
	class_function_comment(cn, fn, ad_txt);
	ad_txt.erase();
if (classname.size()==0 && cn!="::") {
	return;
}

	DBM(cout << "ADDING FUNCTION " << fn << " in class " << cn << endl;)

	string all;
	p=function_name.begin();
	e=function_name.end();
	while(p!=e) {
		if (all.size()!=0 && *p!="(" && *p!=")" && *p!="," && all[all.size()-1]!='(' && all[all.size()-1]!='~')
			all+=" ";
		all+=trim(*p);
		p++;
	}

	class_found_function(cn, fn, all, crnt_access);
}

string
current_class_name()
{
	string cn;
	TClassInfoVec::iterator p,e;
	p=classname.begin();
	e=classname.end();
	while(p!=e) {
		if (cn.size()!=0)
			cn+="::";
		cn+=(*p).name;
		p++;
	}
	if (cn.empty())
		cn="::";
	return cn;
}

TClass*
current_class()
{
	TClassMap::iterator p = class_map.find(current_class_name());
	if (p!=class_map.end())
		return (*p).second;
	return NULL;
}

// `function buffer' is a rather stupid name, because the might be some
// other stuff stored in it: attributes!!!
// please not that this stuff fails on function pointers
void check_function_buffer()
{
	if (state.top()!=FUNCTION &&
	    !af_was_function && 
	    function_name.size()>1)
	{
		if (function_name[0]=="friend")
			return;
		if (function_name[0]=="extern")
			return;

		TClass *c = current_class();
		if (!c)
			return;

		string type;
		TStringVec::iterator p,a,e;
		p=a=function_name.begin();
		e=function_name.end();

		// set `a' to the first attribute name
		while(a!=e) {
			if (*a=="," || 				// int a ,
					*a=="[" ||				// int a [
					*a==":" || 				// int a :
					*a=="=")					// int a =
			{
				break;
			}
			if (*a=="*") {
				a++;
				break;
			}
			a++;
		}
		a--;

		// construct type name
		while(p!=a) {
			if (!type.empty())
				type+=" ";
			type+=*p;
			p++;
		}

//		cout << "CLASS: " << c->name << endl;
//		cout << "TYPE : " << type << endl;
		string attr;
		string name;
		bool in_name=true;
		while(p!=e) {
			if (*p==",") {
//				cout << "  " << attr << "[" << name << "]" << endl;
				class_found_attribute(c,name,type,attr,crnt_access);
				attr.erase();
				in_name=true;
			} else if (*p==":" || *p=="=") {
				in_name=false;
			} else if (in_name) {
				if ( isalpha(*(*p).c_str()) || *(*p).c_str()=='_' )
					name=*p;
				attr+=*p;
			}
			p++;
		}
//		cout << "  " << attr << "  [" << name << "]" << endl << endl;
		class_found_attribute(c,name,type,attr,crnt_access);
	}
}

void begin_html(fstream &out, const string &title)
{
	out << "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0//EN\">\n"
			<< "<HTML>\n"
			<< "  <HEAD>\n"
			<< "    <TITLE>\n"
			<< "      ";
	out << title;
	out << "\n    </TITLE>\n"
			<< "  </HEAD>\n"
			<< "  <BODY BGCOLOR=#FFFFFF>\n";
}

void end_html(fstream &out)
{
	out << "    <HR NOSHADE>" << endl
			<< "    <P ALIGN=CENTER><SMALL>" << endl
			<< "      This page was generated with Stupid -- Another stupid C++ to HTML generator<BR>" << endl
			<< "      Written 1998-2000 by The Wizards of Zilog<BR>" << endl
			<< "      Copyright &copy; 1998-2000 by the <A HREF=\"http://www.mark13.de/toad/\">TOAD Project</A>" << endl
			<< "    </SMALL></P>" << endl
			<< "  </BODY>" << endl
			<< "</HTML>";
}

static const char *header_filter="*/include/toad/*.hh";
void output_tree(ostream &out, const string &what, unsigned depth=0);
void output_multiple(ostream &out);

void output_html()
{
	string directory="../reference/";
	string filename;
	fstream out;

	TClassMap::iterator p, e, prev, next;

	// create index file
	//------------------------------
	filename=directory+"index.html";
	out.open(filename.c_str(), ios::out, 0644);

	begin_html(out, "TOAD Reference: Index");

	// tree
	out << "[<A HREF=\"tree.html\">Tree</A>]" << endl;

	out << "<H1>Index</H1>" << endl
			<< "<HR NOSHADE>" << endl;

	out << "<H2>Class Index</H2>" << endl
			<< "<TABLE BORDER=0 WIDTH=100%>" << endl
			<< "  <TR>" << endl
			<< "    <TD VALIGN=TOP>" << endl;

	unsigned n=0;
	p = class_map.begin();
	e = class_map.end();
	while(p!=e) {
		if (!(*p).second->is_template &&
			  wildcard(header_filter, (*p).second->file.c_str()) )
		{
			n++;
		}			
		p++;
	}
	n=(n+2)/3;
	unsigned i=0;
	
	p = class_map.begin();
	while(p!=e) {
		if (!(*p).second->is_template &&
			  wildcard(header_filter, (*p).second->file.c_str()) )
		{
			out << "<A HREF=\"" << (*p).second->name << ".html\">"
					<< (*p).second->name << "</A><BR>" << endl;
			i++;
			if (i==n) {
				i=0;
				out << "    </TD>" << endl
						<< "    <TD VALIGN=TOP>" << endl;
			}
		}			
		p++;
	}
	
	out << "    </TD>" << endl
			<< "  </TR>" << endl
			<< "</TABLE>" << endl
			<< endl;

	out << "<H2>Template Index</H2>" << endl;
	p = class_map.begin();
	e = class_map.end();
	while(p!=e) {
		if ((*p).second->is_template &&
			  wildcard(header_filter, (*p).second->file.c_str()) )
		{
			out << "      <A HREF=\"" << (*p).second->name << ".html\">"
					<< (*p).second->name << "</A><BR>" << endl;
		}			
		p++;
	}

	end_html(out);
	out.close();
	
	// create class tree
	//------------------------------
	filename=directory+"tree.html";
	out.open(filename.c_str(), ios::out, 0644);

	begin_html(out, "TOAD Reference: Class Tree");
	// index
	out << "[<A HREF=\"index.html\">Index</A>]" << endl;
			
	out << "<H1>Class Tree</H1>" << endl
			<< "<HR NOSHADE>" << endl;

	out << "<H2>Classes with Single Inheritance</H2>" << endl;
	out << "<PRE>" << endl;
	output_tree(out, "");
	out << "</PRE>" << endl;	

	out << "<H2>Classes with Multiple Inheritance</H2>" << endl;
	out << "<PRE>" << endl;
	output_multiple(out);	
	out << "</PRE>" << endl;	
	
	end_html(out);
	out.close();

	// create class files
	//------------------------------
	prev=next=class_map.end();
	p = class_map.begin();
	e = class_map.end();
	while(p!=e) {
		TClass *c = (*p).second;
		if (wildcard(header_filter, c->file.c_str()) )	{
			filename=directory+c->name+".html";
			out.open(filename.c_str(), ios::out, 0644);
			begin_html(out, c->name);

			// previous
			if (prev!=class_map.end() && !c->is_template) {
				out << "[<A HREF=\"" << (*prev).second->name << ".html\">"
						<< (*prev).second->name << "</A>] ";
			}
			prev = p;
			
			// index
			out << "[<A HREF=\"index.html\">Index</A>]" << endl;
			
			// tree
			out << "[<A HREF=\"tree.html\">Tree</A>]" << endl;

			// next
			next = p;
			if (next!=e)
				next++;
			while(next!=e) {
				if (!(*next).second->is_template && 
						wildcard(header_filter, (*next).second->file.c_str()) )
					break;
				next++;
			}
			if (next!=e && !c->is_template) {
				out << "[<A HREF=\"" << (*next).second->name << ".html\">"
						<< (*next).second->name << "</A>] ";
			}
			
			out << "<H1>Class " << c->name << "</H1>" << endl
					<< "<HR NOSHADE>" << endl;

			unsigned pos = c->file.find("include/toad")+8;
			out << "<B>File:</B> &lt;" << c->file.substr(pos) << "&gt;<P>" << endl;
			
			out << c->comment << "<P>" << endl;

			// super classes
			//------------------------------
			out << "<H2>Super Classes</H2>" << endl;
			
			TStringVec::iterator ps,es;
			ps = (*p).second->super.begin();
			es = (*p).second->super.end();
			while(ps!=es) {
				out << "<A HREF=\"" << *ps << ".html\">"
						<< *ps << "</A><BR>" << endl;
				ps++;
			}

#if 0
			// derived classes
			//------------------------------
			out << "<H2>Derived Classes</H2>" << endl
					<< "<PRE>";
			output_tree(out, c->name);
			out << "</PRE>" << endl
					<< endl;
#endif

			// attributes
			//------------------------------
			out << "<H2>Attributes</H2>" << endl;

			TAttrMap::iterator pa,ea;
			pa = c->attr_map.begin();
			ea = c->attr_map.end();
			while(pa!=ea) {
				TAttribut *a = (*pa).second;
				if (a->access!=PRIVATE) {
					switch(a->access) {
						case PUBLIC: out << "public "; break;
						case PROTECTED: out << "protected "; break;
						case PRIVATE: out << "private "; break;
					}
					out << a->type << " " << a->name << "<BR>" << endl;
				}
				pa++;
			}

			// methods
			//------------------------------
			out << "<H2>Methods</H2>" << endl;
			
			TFuncMap::iterator pf, ef;
			pf = (*p).second->func_map.begin();
			ef = (*p).second->func_map.end();
			while(pf!=ef) {
				TFunction::TIncarnationVec::iterator pn,en;
				pn = (*pf).second->incarnation.begin();
				en = (*pf).second->incarnation.end();
				bool print = false;
				while(pn!=en) {
					switch((*pn).access) {
						case PUBLIC:
						case PROTECTED:
							print=true;
							break;
						case PRIVATE:
							break;
					}
					pn++;
				}
				
				if ((*pf).second->name[0]=='_')
					print=false;
				
				if (print) {
					out << "<TABLE WIDTH=100%><TR><TD BGCOLOR=black>\n"
							<< "  <TABLE WIDTH=100% BORDER=0><TR><TD BGCOLOR=gray>\n"
							<< "    <FONT FACE=\"helvetica, sans-serif\" COLOR=#FFFFFF SIZE=4><B>&nbsp;"
							<< (*pf).second->name << endl
							<< "    </B></FONT></TR></TD><TR><TD BGCOLOR=silver><FONT FACE=\"helvetica, sans-serif\">\n";

					pn = (*pf).second->incarnation.begin();
					en = (*pf).second->incarnation.end();
					while(pn!=en) {
						switch((*pn).access) {
							case PUBLIC: out << "public "; break;
							case PROTECTED: out << "protected "; break;
							case PRIVATE: out << "private "; break;
						}
						out << (*pn).fullname << "<BR>" << endl;
						pn++;
					}
				
					out << "</FONT></TD></TR></TABLE></TR></TD><TR><TD BGCOLOR=white>\n"
							<< (*pf).second->comment << endl
							<< "</TR></TD></TABLE>\n\n";
				}
				pf++;
			}

			end_html(out);
			out.close();
		}			
		p++;
	}
}

void output_tree(ostream &out, const string &what, unsigned depth=0)
{
	TClassMap::iterator p, e;
	p = class_map.begin();
	e = class_map.end();
	while(p!=e) {
		if (wildcard(header_filter, (*p).second->file.c_str()) )
		{
			bool flag = false;
			if( what.size()==0 && (*p).second->super.empty() ) {
				flag = true;
			} else {
				unsigned s = (*p).second->super.size();
				for(unsigned i=0; i<s; i++) {
					if ( (*p).second->super[i]==what ) {
						flag = true;
						break;
					}
				}
			}
			if (flag) {
				for(unsigned i=0; i<depth; i++)
					out << "  ";
				out << "<A HREF=\"" << (*p).second->name << ".html\">" << (*p).second->name << "</A>";
				if ((*p).second->super.size()>1) {
					out << "  (<I><A HREF=\"#" << (*p).second->name << "\">multiple</A></I>)" << endl;
				} else {
					out << endl;
					output_tree(out, (*p).second->name, depth+1);
				}
			}
		}			
		p++;
	}
}

/*
	(*p).second->file		header
	(*p).second->name		class name
			TStringVec::iterator ps,es;
			ps = (*p).second->super.begin();
			es = (*p).second->super.end();
				*ps
*/

void output_multiple(ostream &out)
{
	TClassMap::iterator p, e;
	p = class_map.begin();
	e = class_map.end();
	while(p!=e) {
		if (wildcard(header_filter, (*p).second->file.c_str()) )
		{
			if( (*p).second->super.size()>1 ) {
				out << "<A NAME=\"" << (*p).second->name << "\">";
				TStringVec::iterator ps,es;
				ps = (*p).second->super.begin();
				es = (*p).second->super.end();
				while(ps!=es) {
					out << "<A HREF=\"" << *ps << ".html\">" << *ps << "</A>";
					ps++;
					if (ps!=es)
						out << ", ";
				}
				out << endl
						<< "  <B><A HREF=\"" << (*p).second->name << ".html\">" << (*p).second->name << "</A></B>" << endl;
				output_tree(out, (*p).second->name, 2);
				out << endl;
			}
		}			
		p++;
	}
}

/*
	- list of sourcefiles
	- destination directory
	- `-D' and `-I' directives
*/

int main()
{
#if 1
	const char *dir[] = {
		"../../src",
		"../../src/io",
		"../../src/gadget",
		"../../src/dnd",
		"../../src/pen",
		"../../src/util",
		NULL
	};
	const char **dp = dir;
	while(*dp) {
		DIR *dd = opendir(*dp);
		if (dd==NULL) {
			perror("opendir");
			exit(1);
		}
		dirent *de;
		while( (de=readdir(dd))!=NULL ) {
			if (wildcard("*.cc", de->d_name)) {
				string fn = *dp;
				fn+="/";
				fn+=de->d_name;
				parse_file(fn.c_str());
			}
		}
		closedir(dd);
		dp++;
	}
#else
	parse_file("../../src/io/urlstream.cc");
	parse_file("../../src/io/serializable.cc");
#endif
	output_html();
}
