/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for X-Windows
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <toad/toad.hh>
#include <toad/scrollbar.hh>
#include <toad/region.hh>
#include <toad/form.hh>
#include <toad/menubar.hh>
#include <toad/filedialog.hh>
#include <toad/scrolledarea.hh>

class TMainWindow: public TForm
{
	public:
		typedef TForm super;
		TMainWindow(TWindow *p, const string &t):super(p,t){}
	protected:
		void create();
		void menuQuit();
};

class TImageViewer: public TScrolledArea
{
	public:
		typedef TScrolledArea super;
		TImageViewer(TWindow *p, const string &t);
		void Load();
		void paint();
		TBitmap bmp;
};

int ToadMain()
{
	return TMainWindow(NULL, "TOAD View").Run();
};

void TMainWindow::create()
{
	TMenuBar *mb = new TMenuBar(this,"menubar");
	TMenuItem *mi;
	TImageViewer *view = new TImageViewer(this, "image");
	
	mb->BgnPulldown("File");
	mi = mb->AddItem("Open...");
	CONNECT(mi->sigActivate, view, Load);
	mi = mb->AddItem("Quit");
	CONNECT(mi->sigActivate, this, menuQuit);
	mb->EndPulldown();
	
	Attach(mb, SIDE_TOP | SIDE_LEFT | SIDE_RIGHT, ATTACH_FORM);
	Attach(view, SIDE_TOP, ATTACH_WINDOW, mb);
	Attach(view, SIDE_LEFT | SIDE_RIGHT | SIDE_BOTTOM, ATTACH_FORM);
}

void TMainWindow::menuQuit()
{
	PostQuitMessage(0);
}

TImageViewer::TImageViewer(TWindow *p, const string &t)
	:super(p,t)
{
	SetBackground(191,191,191);
}

void TImageViewer::Load()
{
	TFileDialog dlg(NULL,"Imageviewer: Open..");
	TBitmap::GetInputFilter(dlg);
	dlg.DoModal();
	if (dlg.GetResult()==IDOK) {
		try {
			bmp.Load(dlg.GetFilename().c_str());
		} catch(exception &e) {
			MessageBox(NULL, "Error", e.what(), MB_ICONINFORMATION|MB_OK);
			return;
		}
		SetArea(bmp.width,bmp.height, 0,0, 1,1);
		Invalidate();
	}
}

void TImageViewer::paint()
{
	TPen pen(this);
	ClipPen(pen);
	pen.DrawBitmap(-area_x,-area_y,bmp);
}
