/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for X-Windows
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,   
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public 
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

#include <toad/toad.hh>
#include <toad/dialog.hh>
#include <toad/listbox.hh>

class TMyWindow:
	public TDialog
{
		typedef TDialog super;
	public:
		TMyWindow(TWindow *p, const string &t);
};

int ToadMain()
{
  return TMyWindow(NULL, "Listbox Example").Run();
}

TMyWindow::TMyWindow(TWindow *p, const string &t):
	super(p,t)
{
	static const char* name[] = {
		"blueberry",
		"strawberry",
		"grape",
		"lime",
		"tangerine",
		"bondi-blue",
		"ibm-blue",
		"cray-red",
		"sgi-brown",
		"black-sabbath",
		"deep-purple",
		NULL
	};
	
	TListBox *lb;
	
	lb = new TListBox(this, "listbox", name);
		lb->SetShape(5,5,150,100);
		
	lb = new TListBox(this, "listbox", name);
		lb->SetType(TListBox::MULTIPLE);
		lb->SetShape(160,5,150,100);
		
	SetSize(315,110);
}
