/*
 * TPaint -- a simple bitmap editor
 * Copyright (C) 1996-98 by Mark-Andr Hopf
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <toad/toad.hh>
#include <toad/mdiwindow.hh>
#include <toad/dialog.hh>
#include <toad/textfield.hh>
#include <toad/pushbutton.hh>

#include "BitmapEditor.hh"
#include "NewBitmapDialog.hh"

TNewBitmapDialog::TNewBitmapDialog(TWindow *p,const string &t,TMDIWindow *m)
:TDialog(p,t)
{
	mdi=m;

	w = h = 32;
	zoom = 1;

	TPushButton *pb;
	pb = new TPushButton(this, "ok");
		OLD_CONNECT(this, actOk, pb, pb->sigActivate);
	pb = new TPushButton(this, "close");
		OLD_CONNECT(this, closeRequest, pb, pb->sigActivate);

	TTextField *tf;		
	tf = new TTextField(this, "width", &w);
	tf = new TTextField(this, "height", &h);
	tf = new TTextField(this, "zoom", &zoom);
	
	DoLayout("TNewBitmapDialog");
}

void TNewBitmapDialog::actOk()
{
	Apply();
	
	if (h<=0 || w<=0)
	{
		char buffer[80];
		sprintf(buffer, "%i,%i is a wrong size.",w,h);
		MessageBox(this, Title(), buffer, MB_OK | MB_ICONEXCLAMATION);
		return;
	}
	
	if (zoom<=0)
	{
		MessageBox(this, Title(), "'zoom' must be a value >0", MB_OK | MB_ICONEXCLAMATION);
		return;
	}
	
	TBitmapEditor *be;
	be = new TBitmapEditor(mdi, "(unnamed2)");
	be->SetEditSize(w,h);
	be->SetEditZoom(zoom);
	be->Create();
	EndDialog(this);
}
