/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,   
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

#include <toad/gadget.hh>
#include <toad/gadgeteditor.hh>

void 
TGFrame::paint(TPen &pen, EPaintType type)
{
	TPoint p[3];
	pen.SetColor(TColor::WHITE);
	TRectangle r(p1, p2);
	p[0].Set(r.x    	, r.y+r.h-1);
	p[1].Set(r.x+r.w-1, r.y+r.h-1);
	p[2].Set(r.x+r.w-1, r.y);
	pen.DrawLines(p,3);

	p[0].Set(r.x+1  , r.y+r.h-2);
	p[1].Set(r.x+1  , r.y+1);
	p[2].Set(r.x+r.w-2, r.y+1);
	pen.DrawLines(p,3);
	pen.SetColor(TColor::GRAY);
	pen.DrawRectangle(r.x,r.y,r.w-1,r.h-1);

	if (!text.empty()) {
		int fh = TOADBase::DefaultFont().Height();
		int tw = TOADBase::DefaultFont().TextWidth(text);
		pen.SetColor(TColor::LIGHTGRAY);
		pen.FillRectangle(r.x+5-1, r.y-fh/2, tw+2, fh);
		pen.SetColor(line_color);
		pen.DrawString(r.x+5, r.y-fh/2, text);
	}

	if (type==EDIT) {
		pen.SetColor(line_color);
		int fh = TOADBase::DefaultFont().Height();
		unsigned dx = pen.TextWidth(text.substr(0, cx))+5;
		int yp = r.y-fh/2;
		pen.DrawLine(r.x+dx,yp,r.x+dx,yp+pen.Height());
	}
}

void
TGFrame::getShape(TRectangle &r)
{
	int a = TOADBase::DefaultFont().Height()/2;
	TGRectangle::getShape(r);
	r.y-=a;
	r.h+=a;
}

double
TGFrame::distance(int mx, int my)
{
//	cout << __PRETTY_FUNCTION__ << endl;
#if 1
	if (!text.empty()) {
		int fh = TOADBase::DefaultFont().Height();
		int tw = TOADBase::DefaultFont().TextWidth(text);
		TRect r(min(p1.x,p2.x)+5-1, min(p1.y,p2.y)-fh/2, tw+2, fh);
		if (r.IsInside(mx, my))
			return INSIDE;
	}
#endif
	filled = false;
//cout << "is " << mx << "," << my
//		 <<" in " << x << "," << y << "," << w << "," << h << endl;
	return TGRectangle::distance(mx,my);
}

unsigned
TGFrame::stop(TGadgetEditor *editor)
{
	return NOTHING;
}

unsigned
TGFrame::keyDown(TGadgetEditor *editor, TKey key, char *txt, unsigned m)
{
//	cout << __PRETTY_FUNCTION__ << endl;
	if (key==TK_RETURN)
		return CONTINUE;

//	int fh = TOADBase::DefaultFont().Height();
//	int tw = TOADBase::DefaultFont().TextWidth(text);
//	TRect r(x+5-1, y-fh/2, tw+2, fh);
	
	editor->InvalidateFigure(this);
	unsigned result = TGText::keyDown(editor, key, txt, m);
//	r.w = TOADBase::DefaultFont().TextWidth(text)+2;
	editor->InvalidateFigure(this);
	return result;
}

bool
TGFrame::getHandle(unsigned handle, TPoint &p)
{
//	cout << __PRETTY_FUNCTION__ << endl;
	return TGRectangle::getHandle(handle, p);
}

unsigned 
TGFrame::mouseLDown(TGadgetEditor *e, int x, int y, unsigned m)
{
//	cout << __PRETTY_FUNCTION__ << endl;

	switch(e->state) {
		case TGadgetEditor::STATE_START_CREATE:
			TGRectangle::mouseLDown(e,x,y,m);
			TGText::mouseLDown(e,x,y,m);
			break;
			
		case TGadgetEditor::STATE_CREATE:
		case TGadgetEditor::STATE_EDIT:
			if (distance(x,y)>RANGE) {
				e->InvalidateFigure(this);
				cout << "stop" << endl;
				return STOP|REPEAT;
			}
			cout << "still in range" << endl;
			break;
			
		default:
			break;
	}
	return CONTINUE;
}

unsigned 
TGFrame::mouseMove(TGadgetEditor *e, int x, int y, unsigned m)
{
	TGRectangle::mouseMove(e,x,y,m);
	return CONTINUE;
}

unsigned 
TGFrame::mouseLUp(TGadgetEditor *e, int x, int y, unsigned m)
{
	TGRectangle::mouseLUp(e,x,y,m);
	return CONTINUE;
}

void
TGFrame::CalcSize()
{
//	cout << __PRETTY_FUNCTION__ << endl;
}
