/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,   
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

#ifndef TUndoableHandleMove
#define TUndoableHandleMove TUndoableHandleMove

#include <toad/gadget.hh>
#include <toad/gadgeteditor.hh>
#include <toad/gadgeteditor/undoable.hh>

class TUndoableHandleMove:
	public TUndoable
{
	public:
		TUndoableHandleMove(TGadget*, unsigned, const TPoint&, const TPoint&);
		void undo();
		void redo();
		
		unsigned handle;
		TPoint oldpos;
		TPoint newpos;
		TGadget *gadget;
};


#endif
