/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef TSerializable
#define TSerializable TSerializable

#include <vector>
#include <map>
#include <string>
#include <toad/io/binstream.hh>

class TSerializable;
class TSerializeBase;

class TInObjectStream:
	public TInBinStream
{
		friend TSerializeBase;
		typedef vector<TSerializable*> TTable;
		TTable table;
		TSerializeBase* used_by;
		bool read_header;
		unsigned long version;
	public:
		TInObjectStream(istream *is):
			TInBinStream(is) { used_by=NULL; read_header=false; }
};

class TOutObjectStream:
	public TOutBinStream
{
		friend TSerializeBase;
		typedef map<string,unsigned> TTable;
		TTable table;
		TSerializeBase* used_by;
		bool wrote_header;
	public:
		TOutObjectStream(ostream *os):
			TOutBinStream(os) { used_by=NULL; wrote_header=false; }
};

class TCloneable
{
	public:
		virtual TCloneable* clone() = 0;
};

class TSerializable: public TCloneable
{
	public:
		virtual void store(TOutObjectStream&, ulong version) = 0;
		virtual void restore(TInObjectStream&, ulong version) = 0;
};

class TSerializeBase
{
		struct TNode {
			TNode(TSerializable* o, const string &n):
				obj(o), name(n) {}
			TSerializable *obj;
			string name;
		};
		typedef vector<TNode> TSerializableBuffer;
		TSerializableBuffer _buffer;
		ulong version;
	public:
		TSerializeBase();
		~TSerializeBase();
		void SetVersion(ulong v) { version = v; }
		void Register(TSerializable *obj, const string &name);
		void UnregisterAll();
		
		void Store(TOutObjectStream &file, TSerializable *obj);
		TSerializable* Restore(TInObjectStream &file);
};

#endif
