/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

#ifndef TLBA_STLVectorPString
#define TLBA_STLVectorPString TLBA_STLVectorPString

class TLBA_STLVectorPString: public TLBAdapter
{
		vector<const string*> *vec;
	public:
		TLBA_STLVectorPString(vector<const string*> *v){vec=v;}
		TLBA_STLVectorPString(vector<string*> *v){vec=reinterpret_cast<vector<const string*>*>(v);}
		unsigned ItemHeight();
		unsigned ItemCount();
		void PrintItem(int x,int y,unsigned item,TPen &);
};

inline unsigned TLBA_STLVectorPString::ItemHeight()
{
	return TOADBase::DefaultFont().Height();
}

inline unsigned TLBA_STLVectorPString::ItemCount()
{
	return vec->size();
}

inline void TLBA_STLVectorPString::PrintItem(int x,int y,unsigned item,TPen &pen)
{
	if (item>=vec->size()) return;
	pen.DrawString(x,y,*vec->operator[](item));
}

#endif
