/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,   
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

#include <toad/types.hh>

void TRectangle::Set(int ix, int iy, int iw, int ih)
{
	x = ix;
	y = iy;
	w = iw;
	h = ih;
	if (w<0) {
		w=-w;
		x-=w-1;
	}
	if (h<0) {
		h=-h;
		y-=h-1;
	}
}

void TRectangle::Set(const TPoint &p1, const TPoint &p2)
{
	x = p1.x;
	y = p1.y;
	w = p2.x-p1.x;
	h = p2.y-p1.y;
	if (w<0) {
		w=-w;
		x-=w-1;
	}
	if (h<0) {
		h=-h;
		y-=h-1;
	}
	w++;
	h++;		
}
