/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.alignment;

import dr.app.bss.XMLExporter;
import dr.app.tools.NexusExporter;
import dr.evolution.alignment.Alignment;
import dr.evolution.alignment.PatternList;
import dr.evolution.alignment.Patterns;
import dr.evolution.datatype.Codons;
import dr.evolution.datatype.DataType;
import dr.evolution.datatype.GeneralDataType;
import dr.evolution.sequence.Sequence;
import dr.evolution.sequence.Sequences;
import dr.evolution.sequence.UncertainSequence;
import dr.evolution.util.Taxon;
import dr.evolution.util.TaxonList;
import dr.util.NumberFormatter;
import dr.util.XHTMLable;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class SimpleAlignment
extends Sequences
implements Alignment,
XHTMLable {
    private OutputType outputType = OutputType.FASTA;
    private DataType dataType = null;
    private int siteCount = 0;
    private boolean siteCountKnown = false;
    private boolean countStatistics = !(this.dataType instanceof Codons) && !(this.dataType instanceof GeneralDataType);

    public SimpleAlignment() {
    }

    public SimpleAlignment(Alignment alignment, TaxonList taxonList) {
        for (int i = 0; i < taxonList.getTaxonCount(); ++i) {
            Taxon taxon = taxonList.getTaxon(i);
            Sequence sequence = alignment.getSequence(alignment.getTaxonIndex(taxon));
            this.addSequence(sequence);
        }
    }

    public void setOutputType(OutputType outputType) {
        this.outputType = outputType;
    }

    @Override
    public List<Sequence> getSequences() {
        return Collections.unmodifiableList(this.sequences);
    }

    public void updateSiteCount() {
        this.siteCount = 0;
        int n = this.getSequenceCount();
        for (int i = 0; i < n; ++i) {
            int n2 = this.getSequence(i).getLength();
            if (n2 <= this.siteCount) continue;
            this.siteCount = n2;
        }
        this.siteCountKnown = true;
    }

    @Override
    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public int getSiteCount(DataType dataType) {
        return this.getSiteCount();
    }

    public char getChar(int n, int n2) {
        return this.getSequence(n).getChar(n2);
    }

    @Override
    public String getAlignedSequenceString(int n) {
        return this.getSequence(n).getSequenceString();
    }

    @Override
    public String getUnalignedSequenceString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.getSiteCount();
        for (int i = 0; i < n2; ++i) {
            int n3 = this.getState(n, i);
            if (this.dataType.isGapState(n3)) continue;
            stringBuffer.append(this.dataType.getChar(n3));
        }
        return stringBuffer.toString();
    }

    @Override
    public void addSequence(Sequence sequence) {
        if (this.dataType == null) {
            if (sequence.getDataType() == null) {
                this.dataType = sequence.guessDataType();
                sequence.setDataType(this.dataType);
            } else {
                this.setDataType(sequence.getDataType());
            }
        } else if (sequence.getDataType() == null) {
            sequence.setDataType(this.dataType);
        } else if (this.dataType != sequence.getDataType()) {
            throw new IllegalArgumentException("Sequence's dataType does not match the alignment's");
        }
        int n = sequence.getInvalidChar(this.dataType);
        if (n >= 0) {
            throw new IllegalArgumentException("Sequence of " + sequence.getTaxon().getId() + " contains invalid char '" + sequence.getChar(n) + "' at index " + n);
        }
        super.addSequence(sequence);
        this.updateSiteCount();
    }

    @Override
    public void insertSequence(int n, Sequence sequence) {
        if (this.dataType == null) {
            if (sequence.getDataType() == null) {
                this.dataType = sequence.guessDataType();
                sequence.setDataType(this.dataType);
            } else {
                this.setDataType(sequence.getDataType());
            }
        } else if (sequence.getDataType() == null) {
            sequence.setDataType(this.dataType);
        } else if (this.dataType != sequence.getDataType()) {
            throw new IllegalArgumentException("Sequence's dataType does not match the alignment's");
        }
        int n2 = sequence.getInvalidChar(this.dataType);
        if (n2 >= 0) {
            throw new IllegalArgumentException("Sequence of " + sequence.getTaxon().getId() + " contains invalid char '" + sequence.getChar(n2) + "' at index " + n2);
        }
        super.insertSequence(n, sequence);
    }

    @Override
    public int getSiteCount() {
        if (!this.siteCountKnown) {
            this.updateSiteCount();
        }
        return this.siteCount;
    }

    @Override
    public int[] getSitePattern(int n) {
        int n2 = this.getSequenceCount();
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            Sequence sequence = this.getSequence(i);
            nArray[i] = n >= sequence.getLength() ? this.dataType.getGapState() : sequence.getState(n);
        }
        return nArray;
    }

    @Override
    public double[][] getUncertainSitePattern(int n) {
        if (this.areUncertain()) {
            double[][] dArrayArray = new double[this.getSequenceCount()][];
            for (int i = 0; i < this.getSequenceCount(); ++i) {
                int[] nArray;
                Sequence sequence = this.getSequence(i);
                if (n > sequence.getLength()) {
                    dArrayArray[i] = new double[this.dataType.getStateCount()];
                    Arrays.fill(dArrayArray[i], 1.0);
                    continue;
                }
                if (sequence instanceof UncertainSequence) {
                    dArrayArray[i] = ((UncertainSequence)sequence).getUncertainPattern(n);
                    continue;
                }
                dArrayArray[i] = new double[this.dataType.getStateCount()];
                for (int n2 : nArray = this.dataType.getStates(sequence.getState(n))) {
                    dArrayArray[i][n2] = 1.0;
                }
            }
            return dArrayArray;
        }
        throw new UnsupportedOperationException("getUncertainSitePattern not implemented yet");
    }

    @Override
    public int getPatternIndex(int n) {
        return n;
    }

    @Override
    public int getState(int n, int n2) {
        Sequence sequence = this.getSequence(n);
        if (n2 >= sequence.getLength()) {
            return this.dataType.getGapState();
        }
        return sequence.getState(n2);
    }

    @Override
    public double[] getUncertainState(int n, int n2) {
        throw new UnsupportedOperationException("getUncertainState not implemented yet");
    }

    public void setState(int n, int n2, int n3) {
        Sequence sequence = this.getSequence(n);
        if (n2 >= sequence.getLength()) {
            throw new IllegalArgumentException();
        }
        sequence.setState(n2, n3);
    }

    @Override
    public int getPatternCount() {
        return this.getSiteCount();
    }

    public int getInvariantCount() {
        int n = 0;
        for (int i = 0; i < this.getSiteCount(); ++i) {
            int[] nArray = this.getSitePattern(i);
            if (!Patterns.isInvariant(nArray)) continue;
            ++n;
        }
        return n;
    }

    public int getUniquePatternCount() {
        Patterns patterns = new Patterns(this);
        return patterns.getPatternCount();
    }

    public int getInformativeCount() {
        Patterns patterns = new Patterns(this);
        int n = 0;
        for (int i = 0; i < patterns.getPatternCount(); ++i) {
            int[] nArray = patterns.getPattern(i);
            if (!this.isInformative(nArray)) continue;
            n = (int)((double)n + patterns.getPatternWeight(i));
        }
        return n;
    }

    public int getSingletonCount() {
        Patterns patterns = new Patterns(this);
        int n = 0;
        for (int i = 0; i < patterns.getPatternCount(); ++i) {
            int[] nArray = patterns.getPattern(i);
            if (Patterns.isInvariant(nArray) || this.isInformative(nArray)) continue;
            n = (int)((double)n + patterns.getPatternWeight(i));
        }
        return n;
    }

    private boolean isInformative(int[] nArray) {
        int n;
        int[] nArray2 = new int[this.getStateCount()];
        for (n = 0; n < nArray.length; ++n) {
            int n2 = nArray[n];
            nArray2[n2] = nArray2[n2] + 1;
        }
        n = 0;
        boolean bl = false;
        for (int i = 0; i < nArray2.length; ++i) {
            if (nArray2[i] <= 1) continue;
            if (n == 0) {
                n = 1;
                continue;
            }
            bl = true;
        }
        return bl;
    }

    @Override
    public int getStateCount() {
        return this.getDataType().getStateCount();
    }

    @Override
    public int getPatternLength() {
        return this.getSequenceCount();
    }

    @Override
    public int[] getPattern(int n) {
        return this.getSitePattern(n);
    }

    @Override
    public double[][] getUncertainPattern(int n) {
        throw new UnsupportedOperationException("getUncertainPattern not implemented yet");
    }

    @Override
    public int getPatternState(int n, int n2) {
        return this.getState(n, n2);
    }

    @Override
    public double[] getUncertainPatternState(int n, int n2) {
        throw new UnsupportedOperationException("getUncertainPatternState not implemented yet");
    }

    @Override
    public double getPatternWeight(int n) {
        return 1.0;
    }

    @Override
    public double[] getPatternWeights() {
        double[] dArray = new double[this.siteCount];
        for (int i = 0; i < this.siteCount; ++i) {
            dArray[i] = 1.0;
        }
        return dArray;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public double[] getStateFrequencies() {
        return PatternList.Utils.empiricalStateFrequencies(this);
    }

    @Override
    public boolean areUnique() {
        return false;
    }

    @Override
    public boolean areUncertain() {
        for (Sequence sequence : this.sequences) {
            if (!(sequence instanceof UncertainSequence)) continue;
            return true;
        }
        return false;
    }

    public void setReportCountStatistics(boolean bl) {
        this.countStatistics = bl;
    }

    public String toString() {
        return this.outputType.makeOutputString(this);
    }

    @Override
    public String toXHTML() {
        int n;
        int n2;
        String string = "<p><em>Alignment</em> data type = ";
        string = string + this.getDataType().getDescription();
        string = string + ", no. taxa = ";
        string = string + this.getTaxonCount();
        string = string + ", no. sites = ";
        string = string + this.getSiteCount();
        string = string + "</p>";
        string = string + "<pre>";
        int n3 = 0;
        for (n2 = 0; n2 < this.getTaxonCount(); ++n2) {
            n = this.getTaxonId(n2).length();
            if (n <= n3) continue;
            n3 = n;
        }
        for (n2 = 0; n2 < this.getTaxonCount(); ++n2) {
            n = this.getTaxonId(n2).length();
            string = string + this.getTaxonId(n2);
            for (int i = n; i <= n3; ++i) {
                string = string + " ";
            }
            string = string + this.getAlignedSequenceString(n2) + "\n";
        }
        string = string + "</pre>";
        return string;
    }

    public static enum OutputType {
        FASTA("fasta", "fsa"){

            @Override
            public String makeOutputString(SimpleAlignment simpleAlignment) {
                NumberFormatter numberFormatter = new NumberFormatter(6);
                StringBuffer stringBuffer = new StringBuffer();
                if (simpleAlignment.countStatistics) {
                    stringBuffer.append("Site count = ").append(simpleAlignment.getSiteCount()).append("\n");
                    stringBuffer.append("Invariant sites = ").append(simpleAlignment.getInvariantCount()).append("\n");
                    stringBuffer.append("Singleton sites = ").append(simpleAlignment.getSingletonCount()).append("\n");
                    stringBuffer.append("Parsimony informative sites = ").append(simpleAlignment.getInformativeCount()).append("\n");
                    stringBuffer.append("Unique site patterns = ").append(simpleAlignment.getUniquePatternCount()).append("\n\n");
                }
                for (int i = 0; i < simpleAlignment.getSequenceCount(); ++i) {
                    String string = numberFormatter.formatToFieldWidth(simpleAlignment.getTaxonId(i), 10);
                    stringBuffer.append(">" + string + "\n");
                    stringBuffer.append(simpleAlignment.getAlignedSequenceString(i) + "\n");
                }
                return stringBuffer.toString();
            }
        }
        ,
        NEXUS("nexus", "nxs"){

            @Override
            public String makeOutputString(SimpleAlignment simpleAlignment) {
                StringBuffer stringBuffer = new StringBuffer();
                try {
                    File file = File.createTempFile("tempfile", ".tmp");
                    PrintStream printStream = new PrintStream(file);
                    NexusExporter nexusExporter = new NexusExporter(printStream);
                    stringBuffer.append(nexusExporter.exportAlignment((Alignment)simpleAlignment));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    illegalArgumentException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                return stringBuffer.toString();
            }
        }
        ,
        XML("xml", "xml"){

            @Override
            public String makeOutputString(SimpleAlignment simpleAlignment) {
                StringBuffer stringBuffer = new StringBuffer();
                try {
                    XMLExporter xMLExporter = new XMLExporter();
                    stringBuffer.append(xMLExporter.exportAlignment(simpleAlignment));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    illegalArgumentException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                return stringBuffer.toString();
            }
        };

        private final String text;
        private final String extension;

        private OutputType(String string2, String string3) {
            this.text = string2;
            this.extension = string3;
        }

        public String getText() {
            return this.text;
        }

        public String getExtension() {
            return this.extension;
        }

        public abstract String makeOutputString(SimpleAlignment var1);

        public static OutputType parseFromString(String string) {
            for (OutputType outputType : OutputType.values()) {
                if (outputType.getText().compareToIgnoreCase(string) != 0) continue;
                return outputType;
            }
            return null;
        }

        public static OutputType parseFromExtension(String string) {
            for (OutputType outputType : OutputType.values()) {
                if (outputType.getExtension().compareToIgnoreCase(string) != 0) continue;
                return outputType;
            }
            return null;
        }
    }
}

