/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.continuous;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.util.Taxon;
import dr.evomodel.continuous.TreeTraitNormalDistributionModel;
import dr.evomodel.tree.TreeModel;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.StringAttributeRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class TreeTraitSimulator {
    public static final String SIMULATE_TREE_TRAITS = "treeTraitSimulator";
    public static final String TREE_TRAIT_NAME = "traitName";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new StringAttributeRule("traitName", "The name to be given to the trait to be simulated"), new ElementRule(TreeTraitNormalDistributionModel.class), new ElementRule(TreeModel.class)};

        @Override
        public String getParserName() {
            return TreeTraitSimulator.SIMULATE_TREE_TRAITS;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            String string = xMLObject.getStringAttribute(TreeTraitSimulator.TREE_TRAIT_NAME);
            TreeTraitNormalDistributionModel treeTraitNormalDistributionModel = (TreeTraitNormalDistributionModel)xMLObject.getChild(TreeTraitNormalDistributionModel.class);
            TreeModel treeModel = (TreeModel)xMLObject.getChild(TreeModel.class);
            TreeTraitSimulator treeTraitSimulator = new TreeTraitSimulator(treeTraitNormalDistributionModel, treeModel, string);
            treeTraitSimulator.simulate();
            return treeTraitSimulator;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public String getParserDescription() {
            return "Simulates a trait on a tree";
        }

        @Override
        public Class getReturnType() {
            return TreeTraitSimulator.class;
        }
    };
    TreeModel traitTree = null;
    TreeTraitNormalDistributionModel treeTraitModel = null;
    String traitName = null;

    public TreeTraitSimulator(TreeTraitNormalDistributionModel treeTraitNormalDistributionModel, TreeModel treeModel, String string) {
        this.traitTree = treeModel;
        this.treeTraitModel = treeTraitNormalDistributionModel;
        this.traitName = string;
    }

    public void simulate() {
        double[] dArray = this.treeTraitModel.nextRandom();
        int n = this.traitTree.getTaxonCount();
        int n2 = this.treeTraitModel.getDimTrait();
        double[] dArray2 = new double[n2];
        System.err.println("Playing with generated values...");
        Tree tree = this.treeTraitModel.getTree();
        for (int i = 0; i < n; ++i) {
            NodeRef nodeRef = tree.getExternalNode(i);
            Taxon taxon = tree.getNodeTaxon(nodeRef);
            StringBuilder stringBuilder = new StringBuilder();
            for (int j = 0; j < n2; ++j) {
                if (j > 0) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(dArray[i * n2 + j]);
            }
            taxon.setAttribute(this.traitName, stringBuilder.toString());
        }
    }
}

