/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.continuous.hmc;

import dr.evomodel.continuous.hmc.TreePrecisionTraitProductProvider;
import dr.evomodel.treedatalikelihood.TreeDataLikelihood;
import dr.evomodel.treedatalikelihood.continuous.ContinuousDataLikelihoodDelegate;
import dr.inference.model.Model;
import dr.inference.model.Parameter;

public class CubicOrderTreePrecisionTraitProductProvider
extends TreePrecisionTraitProductProvider {
    private static final boolean DO_CACHE = true;
    private boolean isPrecisionKnown = false;
    private boolean savedIsPrecisionKnown;
    private double[][] treeTraitPrecision;
    private double[][] savedTreeTraitPrecision;

    public CubicOrderTreePrecisionTraitProductProvider(TreeDataLikelihood treeDataLikelihood, ContinuousDataLikelihoodDelegate continuousDataLikelihoodDelegate) {
        super(treeDataLikelihood, continuousDataLikelihoodDelegate);
    }

    @Override
    public double[] getProduct(Parameter parameter) {
        return this.expensiveProduct(parameter, this.getTreeTraitPrecision());
    }

    @Override
    public double[] getMassVector() {
        double[][] dArray = this.likelihoodDelegate.getTreeTraitVariance();
        int n = dArray.length;
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = dArray[i][i];
        }
        return dArray2;
    }

    @Override
    public double getTimeScale() {
        double[][] dArray = this.likelihoodDelegate.getTreeTraitVariance();
        int n = dArray.length;
        double d = Double.MIN_VALUE;
        for (int i = 0; i < n; ++i) {
            d = Math.max(d, dArray[i][i]);
        }
        return Math.sqrt(d);
    }

    @Override
    public double getTimeScaleEigen() {
        return 0.0;
    }

    private double[][] getTreeTraitPrecision() {
        if (!this.isPrecisionKnown) {
            this.treeTraitPrecision = this.likelihoodDelegate.getTreeTraitPrecision();
            this.isPrecisionKnown = true;
        }
        return this.treeTraitPrecision;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        if (model == this.tree) {
            this.isPrecisionKnown = false;
        }
    }

    @Override
    protected void storeState() {
        int n = this.treeTraitPrecision.length;
        if (this.savedTreeTraitPrecision == null) {
            this.savedTreeTraitPrecision = new double[n][n];
        }
        for (int i = 0; i < n; ++i) {
            System.arraycopy(this.treeTraitPrecision[i], 0, this.savedTreeTraitPrecision[i], 0, n);
        }
        this.savedIsPrecisionKnown = this.isPrecisionKnown;
    }

    @Override
    protected void restoreState() {
        double[][] dArray = this.treeTraitPrecision;
        this.treeTraitPrecision = this.savedTreeTraitPrecision;
        this.savedTreeTraitPrecision = dArray;
        this.isPrecisionKnown = this.savedIsPrecisionKnown;
    }
}

