/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.substmodel.codon;

import dr.evolution.datatype.Codons;
import dr.evolution.datatype.DataType;
import dr.evolution.datatype.HiddenCodons;
import dr.evomodel.substmodel.DefaultEigenSystem;
import dr.evomodel.substmodel.EigenDecomposition;
import dr.evomodel.substmodel.EigenSystem;
import dr.evomodel.substmodel.FrequencyModel;
import dr.evomodel.substmodel.codon.GY94CodonModel;
import dr.inference.model.Parameter;
import dr.math.matrixAlgebra.Vector;

public class MarkovModulatedGY94CodonModel
extends GY94CodonModel {
    private static final byte RATE = 5;
    private int hiddenClassCount;
    private Parameter switchingRates;

    public MarkovModulatedGY94CodonModel(HiddenCodons hiddenCodons, Parameter parameter, Parameter parameter2, Parameter parameter3, FrequencyModel frequencyModel) {
        this(hiddenCodons, parameter, parameter2, parameter3, frequencyModel, new DefaultEigenSystem(hiddenCodons.getStateCount()));
    }

    public MarkovModulatedGY94CodonModel(HiddenCodons hiddenCodons, Parameter parameter, Parameter parameter2, Parameter parameter3, FrequencyModel frequencyModel, EigenSystem eigenSystem) {
        super(hiddenCodons, parameter2, parameter3, frequencyModel, eigenSystem);
        this.hiddenClassCount = hiddenCodons.getHiddenClassCount();
        this.switchingRates = parameter;
        this.addVariable(parameter);
        for (int i = 0; i < this.relativeRates.length; ++i) {
            this.relativeRates[i] = 0.0;
        }
    }

    @Override
    protected void setupRelativeRates(double[] dArray) {
        int n;
        int n2;
        int n3;
        double d = this.getKappa();
        double[] dArray2 = this.omegaParameter.getParameterValues();
        double[] dArray3 = this.switchingRates.getParameterValues();
        int n4 = this.stateCount / this.hiddenClassCount;
        int n5 = 0;
        for (int i = 0; i < n4; ++i) {
            for (n3 = i + 1; n3 < n4; ++n3) {
                block9: for (n2 = 0; n2 < this.hiddenClassCount; ++n2) {
                    n = MarkovModulatedGY94CodonModel.getIndex(n2 * n4 + i, n2 * n4 + n3, this.stateCount);
                    switch (this.rateMap[n5]) {
                        case 0: {
                            dArray[n] = 0.0;
                            continue block9;
                        }
                        case 1: {
                            dArray[n] = d;
                            continue block9;
                        }
                        case 2: {
                            dArray[n] = 1.0;
                            continue block9;
                        }
                        case 3: {
                            dArray[n] = d * dArray2[n2];
                            continue block9;
                        }
                        case 4: {
                            dArray[n] = dArray2[n2];
                        }
                    }
                }
                ++n5;
            }
        }
        double[] dArray4 = this.freqModel.getFrequencies();
        n3 = 0;
        for (n2 = 0; n2 < this.hiddenClassCount; ++n2) {
            for (n = n2 + 1; n < this.hiddenClassCount; ++n) {
                for (int i = 0; i < n4; ++i) {
                    int n6 = MarkovModulatedGY94CodonModel.getIndex(n2 * n4 + i, n * n4 + i, this.stateCount);
                    dArray[n6] = dArray3[n3] / dArray4[i];
                }
                ++n3;
            }
        }
    }

    private static int getIndex(int n, int n2, int n3) {
        return (n * (2 * n3 - 3) - n * n) / 2 + n2 - 1;
    }

    @Override
    protected void constructRateMap() {
        this.hiddenClassCount = ((HiddenCodons)this.codonDataType).getHiddenClassCount();
        this.stateCount /= this.hiddenClassCount;
        super.constructRateMap();
        this.stateCount *= this.hiddenClassCount;
    }

    public static void main(String[] stringArray) {
        GY94CodonModel gY94CodonModel = new GY94CodonModel(Codons.UNIVERSAL, new Parameter.Default(1.0), new Parameter.Default(2.0), new FrequencyModel((DataType)Codons.UNIVERSAL, new Parameter.Default(61, 0.01639344262295082)));
        EigenDecomposition eigenDecomposition = gY94CodonModel.getEigenDecomposition();
        FrequencyModel frequencyModel = new FrequencyModel((DataType)HiddenCodons.UNIVERSAL_HIDDEN_2, new Parameter.Default(122, 0.00819672131147541));
        System.err.println("freq = " + new Vector(frequencyModel.getFrequencies()));
        MarkovModulatedGY94CodonModel markovModulatedGY94CodonModel = new MarkovModulatedGY94CodonModel(HiddenCodons.UNIVERSAL_HIDDEN_2, (Parameter)new Parameter.Default(2, 5.0), (Parameter)new Parameter.Default(2, 1.0), new Parameter.Default(2.0), frequencyModel);
        EigenDecomposition eigenDecomposition2 = markovModulatedGY94CodonModel.getEigenDecomposition();
        System.err.println("matrixQ = \n" + markovModulatedGY94CodonModel.printQ());
    }

    @Override
    protected double getMINFDIFF() {
        return 1.0E-10;
    }

    @Override
    protected double getMINFREQ() {
        return 1.0E-10;
    }
}

