/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.preorder;

import dr.evolution.tree.Tree;
import dr.evomodel.continuous.MultivariateDiffusionModel;
import dr.evomodel.treedatalikelihood.continuous.ConjugateRootTraitPrior;
import dr.evomodel.treedatalikelihood.continuous.ContinuousDataLikelihoodDelegate;
import dr.evomodel.treedatalikelihood.continuous.ContinuousRateTransformation;
import dr.evomodel.treedatalikelihood.continuous.ContinuousTraitPartialsProvider;
import dr.evomodel.treedatalikelihood.continuous.PartiallyMissingInformation;
import dr.evomodel.treedatalikelihood.preorder.ConditionalOnTipsRealizedDelegate;
import dr.evomodel.treedatalikelihood.preorder.ConditionalVarianceAndTransform2;
import dr.math.distributions.MultivariateNormalDistribution;
import dr.math.matrixAlgebra.ReadableVector;
import dr.math.matrixAlgebra.WrappedMatrix;
import dr.math.matrixAlgebra.WrappedVector;
import dr.math.matrixAlgebra.WritableVector;
import dr.math.matrixAlgebra.missingData.MissingOps;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public class MultivariateConditionalOnTipsRealizedDelegate
extends ConditionalOnTipsRealizedDelegate {
    private static final boolean DEBUG = false;
    private final PartiallyMissingInformation missingInformation;
    private static final boolean NEW_TIP_WITH_NO_DATA = true;
    private static final boolean NEW_CHOLESKY = false;

    public MultivariateConditionalOnTipsRealizedDelegate(String string, Tree tree, MultivariateDiffusionModel multivariateDiffusionModel, ContinuousTraitPartialsProvider continuousTraitPartialsProvider, ConjugateRootTraitPrior conjugateRootTraitPrior, ContinuousRateTransformation continuousRateTransformation, ContinuousDataLikelihoodDelegate continuousDataLikelihoodDelegate) {
        super(string, tree, multivariateDiffusionModel, continuousTraitPartialsProvider, conjugateRootTraitPrior, continuousRateTransformation, continuousDataLikelihoodDelegate);
        this.missingInformation = new PartiallyMissingInformation(tree, continuousTraitPartialsProvider);
    }

    @Override
    protected void simulateTraitForRoot(int n, int n2) {
        DenseMatrix64F denseMatrix64F = MissingOps.wrap(this.partialNodeBuffer, n2 + this.dimTrait, this.dimTrait, this.dimTrait);
        DenseMatrix64F denseMatrix64F2 = new DenseMatrix64F(this.dimTrait, this.dimTrait);
        MissingOps.safeMult(this.Pd, MissingOps.wrap(this.partialPriorBuffer, n2 + this.dimTrait, this.dimTrait, this.dimTrait), denseMatrix64F2);
        DenseMatrix64F denseMatrix64F3 = new DenseMatrix64F(this.dimTrait, this.dimTrait);
        CommonOps.add((D1Matrix64F)denseMatrix64F, denseMatrix64F2, (D1Matrix64F)denseMatrix64F3);
        DenseMatrix64F denseMatrix64F4 = new DenseMatrix64F(this.dimTrait, this.dimTrait);
        MissingOps.safeInvert2(denseMatrix64F3, denseMatrix64F4, false);
        double[] dArray = new double[this.dimTrait];
        MissingOps.safeWeightedAverage(new WrappedVector.Raw(this.partialNodeBuffer, n2, this.dimTrait), denseMatrix64F, new WrappedVector.Raw(this.partialPriorBuffer, n2, this.dimTrait), denseMatrix64F2, new WrappedVector.Raw(dArray, 0, this.dimTrait), denseMatrix64F4, this.dimTrait);
        DenseMatrix64F denseMatrix64F5 = MultivariateConditionalOnTipsRealizedDelegate.getCholeskyOfVariance(denseMatrix64F4, this.dimTrait);
        MultivariateNormalDistribution.nextMultivariateNormalCholesky(new WrappedVector.Raw(dArray, 0, this.dimTrait), new WrappedMatrix.Raw(denseMatrix64F5.getData(), 0, this.dimTrait, this.dimTrait), 1.0, new WrappedVector.Raw(this.sample, n, this.dimTrait), this.tmpEpsilon);
    }

    @Override
    protected void simulateTraitForNode(int n, int n2, int n3, int n4, int n5, int n6, double d) {
        if (n6 == 1) {
            this.simulateTraitForExternalNode(n, n2, n3, n4, n5, d);
        } else {
            this.simulateTraitForInternalNode(n3, n4, n5, d);
        }
    }

    private void simulateTraitForExternalNode(int n, int n2, int n3, int n4, int n5, double d) {
        DenseMatrix64F denseMatrix64F = MissingOps.wrap(this.partialNodeBuffer, n5 + this.dimTrait, this.dimTrait, this.dimTrait);
        int n6 = MissingOps.countFiniteDiagonals(denseMatrix64F);
        if (n6 == 0) {
            System.arraycopy(this.partialNodeBuffer, n5, this.sample, n3, this.dimTrait);
        } else {
            int n7 = MissingOps.countZeroDiagonals(denseMatrix64F);
            if (n7 == this.dimTrait) {
                double d2 = Math.sqrt(1.0 / d);
                ReadableVector readableVector = this.getMeanBranch(n4);
                MultivariateNormalDistribution.nextMultivariateNormalCholesky(readableVector, new WrappedMatrix.ArrayOfArray(this.cholesky), d2, new WrappedVector.Raw(this.sample, n3, this.dimTrait), this.tmpEpsilon);
            } else if (n6 == this.dimTrait) {
                this.simulateTraitForInternalNode(n3, n4, n5, d);
            } else {
                System.arraycopy(this.partialNodeBuffer, n5, this.sample, n3, this.dimTrait);
                PartiallyMissingInformation.HashedIntArray hashedIntArray = this.missingInformation.getMissingIndices(n, n2);
                int[] nArray = hashedIntArray.getComplement();
                int[] nArray2 = hashedIntArray.getArray();
                for (int denseMatrix64F4 : nArray) {
                    denseMatrix64F.set(denseMatrix64F4, denseMatrix64F4, 0.0);
                }
                DenseMatrix64F denseMatrix64F2 = this.getPrecisionBranch(d);
                DenseMatrix64F denseMatrix64F3 = new DenseMatrix64F(this.dimTrait, this.dimTrait);
                CommonOps.add((D1Matrix64F)denseMatrix64F, denseMatrix64F2, (D1Matrix64F)denseMatrix64F3);
                DenseMatrix64F denseMatrix64F4 = new DenseMatrix64F(this.dimTrait, this.dimTrait);
                CommonOps.invert(denseMatrix64F3, denseMatrix64F4);
                DenseMatrix64F denseMatrix64F5 = MissingOps.wrap(this.sample, n4, this.dimTrait, 1);
                DenseMatrix64F denseMatrix64F6 = MissingOps.wrap(this.partialNodeBuffer, n5, this.dimTrait, 1);
                DenseMatrix64F denseMatrix64F7 = new DenseMatrix64F(this.dimTrait, 1);
                DenseMatrix64F denseMatrix64F8 = new DenseMatrix64F(this.dimTrait, 1);
                CommonOps.mult(denseMatrix64F, denseMatrix64F6, denseMatrix64F7);
                CommonOps.mult(denseMatrix64F2, denseMatrix64F5, denseMatrix64F8);
                CommonOps.addEquals(denseMatrix64F8, denseMatrix64F7);
                CommonOps.mult(denseMatrix64F4, denseMatrix64F8, denseMatrix64F7);
                ConditionalVarianceAndTransform2 conditionalVarianceAndTransform2 = new ConditionalVarianceAndTransform2(denseMatrix64F4, nArray2, nArray);
                DenseMatrix64F denseMatrix64F9 = new DenseMatrix64F(nArray2.length, nArray2.length);
                MissingOps.gatherRowsAndColumns(denseMatrix64F, denseMatrix64F9, nArray2, nArray2);
                WrappedVector wrappedVector = conditionalVarianceAndTransform2.getConditionalMean(this.partialNodeBuffer, n5, denseMatrix64F7.data, 0);
                DenseMatrix64F denseMatrix64F10 = conditionalVarianceAndTransform2.getConditionalVariance();
                double[][] dArray = MultivariateConditionalOnTipsRealizedDelegate.getCholeskyOfVariance(denseMatrix64F10.getData(), nArray2.length);
                MultivariateNormalDistribution.nextMultivariateNormalCholesky(wrappedVector, new WrappedMatrix.ArrayOfArray(dArray), 1.0, new WrappedVector.Indexed(this.sample, n3, nArray2), this.tmpEpsilon);
            }
        }
    }

    ReadableVector getMeanBranch(int n) {
        double[] dArray = new double[this.dimTrait];
        System.arraycopy(this.sample, n, dArray, 0, this.dimTrait);
        double[] dArray2 = new double[this.dimTrait];
        this.cdi.getBranchExpectation(this.actualizationBuffer, dArray, this.displacementBuffer, dArray2);
        return new WrappedVector.Raw(dArray2, 0, this.dimTrait);
    }

    private void simulateTraitForInternalNode(int n, int n2, int n3, double d) {
        if (!Double.isInfinite(d)) {
            WrappedVector.Raw raw = new WrappedVector.Raw(this.partialNodeBuffer, n3, this.dimTrait);
            DenseMatrix64F denseMatrix64F = MissingOps.wrap(this.partialNodeBuffer, n3 + this.dimTrait, this.dimTrait, this.dimTrait);
            ReadableVector readableVector = this.getMeanBranch(n2);
            DenseMatrix64F denseMatrix64F2 = this.getPrecisionBranch(d);
            WrappedVector.Raw raw2 = new WrappedVector.Raw(this.tmpMean, 0, this.dimTrait);
            DenseMatrix64F denseMatrix64F3 = new DenseMatrix64F(this.dimTrait, this.dimTrait);
            DenseMatrix64F denseMatrix64F4 = new DenseMatrix64F(this.dimTrait, this.dimTrait);
            CommonOps.add((D1Matrix64F)denseMatrix64F, denseMatrix64F2, (D1Matrix64F)denseMatrix64F3);
            MissingOps.safeInvert2(denseMatrix64F3, denseMatrix64F4, false);
            MissingOps.weightedAverage((ReadableVector)raw, denseMatrix64F, readableVector, denseMatrix64F2, (WritableVector)raw2, denseMatrix64F4, this.dimTrait);
            double[][] dArray = MultivariateConditionalOnTipsRealizedDelegate.getCholeskyOfVariance(denseMatrix64F4.getData(), this.dimTrait);
            WrappedMatrix.ArrayOfArray arrayOfArray = new WrappedMatrix.ArrayOfArray(dArray);
            MultivariateNormalDistribution.nextMultivariateNormalCholesky(raw2, arrayOfArray, 1.0, new WrappedVector.Raw(this.sample, n, this.dimTrait), this.tmpEpsilon);
        } else {
            System.arraycopy(this.sample, n2, this.sample, n, this.dimTrait);
        }
    }

    private boolean check(ReadableVector readableVector) {
        for (int i = 0; i < readableVector.getDim(); ++i) {
            if (!Double.isNaN(readableVector.get(i))) continue;
            return false;
        }
        return true;
    }

    DenseMatrix64F getPrecisionBranch(double d) {
        if (!this.hasDrift) {
            DenseMatrix64F denseMatrix64F = new DenseMatrix64F(this.dimTrait, this.dimTrait);
            CommonOps.scale(d, this.Pd, denseMatrix64F);
            return denseMatrix64F;
        }
        return DenseMatrix64F.wrap(this.dimTrait, this.dimTrait, this.precisionBuffer);
    }

    DenseMatrix64F getVarianceBranch(double d) {
        if (!this.hasDrift) {
            DenseMatrix64F denseMatrix64F = new DenseMatrix64F(this.dimTrait, this.dimTrait);
            CommonOps.scale(1.0 / d, this.Vd, denseMatrix64F);
            return denseMatrix64F;
        }
        DenseMatrix64F denseMatrix64F = this.getPrecisionBranch(d);
        DenseMatrix64F denseMatrix64F2 = new DenseMatrix64F(this.dimTrait, this.dimTrait);
        CommonOps.invert(denseMatrix64F, denseMatrix64F2);
        return denseMatrix64F2;
    }
}

