/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

public enum DerivativeOrder {
    ZEROTH("zeroth", 0){

        @Override
        public int getDerivativeDimension(int n) {
            return 1;
        }
    }
    ,
    GRADIENT("gradient", 1){

        @Override
        public int getDerivativeDimension(int n) {
            return n;
        }
    }
    ,
    DIAGONAL_HESSIAN("diagonalHessian", 2){

        @Override
        public int getDerivativeDimension(int n) {
            return n;
        }
    }
    ,
    FULL_HESSIAN("Hessian", 3){

        @Override
        public int getDerivativeDimension(int n) {
            return n * n;
        }
    };

    private final String type;
    final int order;

    private DerivativeOrder(String string2, int n2) {
        this.type = string2;
        this.order = n2;
    }

    public abstract int getDerivativeDimension(int var1);

    public final String toString() {
        return this.type;
    }

    public final int getValue() {
        return this.order;
    }
}

