/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.MatrixParameterInterface;
import dr.inference.model.Statistic;
import dr.inference.model.Variable;
import dr.inference.model.VariableListener;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public class DeterminantStatistic
extends Statistic.Abstract
implements VariableListener {
    private final MatrixParameterInterface matrix;
    private final int matrixDim;
    private boolean detKnown = false;
    private double det;
    public static final AbstractXMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private static final String DETERMINANT_STATISTIC = "determinant";

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            MatrixParameterInterface matrixParameterInterface = (MatrixParameterInterface)xMLObject.getChild(MatrixParameterInterface.class);
            if (matrixParameterInterface.getColumnDimension() != matrixParameterInterface.getRowDimension()) {
                throw new XMLParseException("can only calculate determinant for square matrices");
            }
            String string = xMLObject.hasId() ? xMLObject.getId() : (matrixParameterInterface.getId() != null ? "determinant." + matrixParameterInterface.getId() : DETERMINANT_STATISTIC);
            return new DeterminantStatistic(string, matrixParameterInterface);
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return new XMLSyntaxRule[]{new ElementRule(MatrixParameterInterface.class)};
        }

        @Override
        public String getParserDescription() {
            return "Statistic that computes the determinant of a matrix";
        }

        @Override
        public Class getReturnType() {
            return DeterminantStatistic.class;
        }

        @Override
        public String getParserName() {
            return DETERMINANT_STATISTIC;
        }
    };

    public DeterminantStatistic(String string, MatrixParameterInterface matrixParameterInterface) {
        super(string);
        this.matrix = matrixParameterInterface;
        this.matrixDim = matrixParameterInterface.getRowDimension();
        matrixParameterInterface.addParameterListener(this);
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public double getStatisticValue(int n) {
        if (!this.detKnown) {
            double[] dArray = this.matrix.getParameterValues();
            DenseMatrix64F denseMatrix64F = DenseMatrix64F.wrap(this.matrixDim, this.matrixDim, dArray);
            this.det = CommonOps.det(denseMatrix64F);
            this.detKnown = true;
        }
        return this.det;
    }

    @Override
    public void variableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.detKnown = false;
    }
}

