/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.Bounds;
import dr.inference.model.Variable;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class ParameterIntegerParser
extends AbstractXMLObjectParser {
    public static final String DIMENSION = "dimension";
    public static final String VALUE = "value";
    public static final String PARAMETER = "integerParameter";
    private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newIntegerArrayRule("value", true), AttributeRule.newIntegerRule("dimension", true)};

    @Override
    public String getParserName() {
        return PARAMETER;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        int[] nArray = null;
        if (xMLObject.hasAttribute(VALUE)) {
            if (nArray == null) {
                nArray = xMLObject.getIntegerArrayAttribute(VALUE);
            } else {
                int[] nArray2 = xMLObject.getIntegerArrayAttribute(VALUE);
                if (nArray2.length == nArray.length) {
                    System.arraycopy(nArray2, 0, nArray, 0, nArray2.length);
                } else {
                    if (nArray2.length != 1) throw new XMLParseException("value string must have 1 value or dimension values");
                    for (int i = 0; i < nArray.length; ++i) {
                        nArray[i] = nArray2[0];
                    }
                }
            }
        } else {
            nArray = xMLObject.hasAttribute(DIMENSION) ? new int[xMLObject.getIntegerAttribute(DIMENSION)] : new int[]{0};
        }
        Variable.I i = new Variable.I(nArray);
        i.addBounds(new Bounds.Staircase(i));
        return i;
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return this.rules;
    }

    @Override
    public String getParserDescription() {
        return "An integer-valued parameter only for staircase bound.";
    }

    @Override
    public Class getReturnType() {
        return Variable.class;
    }
}

