/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.substmodel;

import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.oldevomodel.substmodel.AbstractNucleotideModel;
import dr.oldevomodel.substmodel.FrequencyModel;
import dr.oldevomodelxml.substmodel.TN93Parser;
import dr.util.Author;
import dr.util.Citable;
import dr.util.Citation;
import java.util.Collections;
import java.util.List;

public class TN93
extends AbstractNucleotideModel
implements Citable {
    private Variable<Double> kappa1Variable = null;
    private Variable<Double> kappa2Variable = null;
    private boolean updateIntermediates = true;
    private double p1a;
    private double p0a;
    private double p3b;
    private double p2b;
    private double a;
    private double b;
    private double p1aa;
    private double p0aa;
    private double p3bb;
    private double p2bb;
    private double p1aIsa;
    private double p0aIsa;
    private double p3bIsb;
    private double p2bIsb;
    private double k1g;
    private double k1a;
    private double k2t;
    private double k2c;
    private double subrateScale;
    public static Citation CITATION = new Citation(new Author[]{new Author("K", "Tamura"), new Author("M", "Nei")}, "Estimation of the number of nucleotide substitutions in the control region of mitochondrial DNA in humans and chimpanzees", 1993, "Mol Biol Evol", 10, 512, 526);

    public TN93(Variable variable, Variable variable2, FrequencyModel frequencyModel) {
        super(TN93Parser.TN93_MODEL, frequencyModel);
        this.kappa1Variable = variable;
        this.kappa2Variable = variable2;
        this.addVariable(variable);
        this.addVariable(variable2);
        variable.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        variable2.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.updateIntermediates = true;
    }

    public final double getKappa1() {
        return this.kappa1Variable.getValue(0);
    }

    public final double getKappa2() {
        return this.kappa2Variable.getValue(0);
    }

    @Override
    protected void frequenciesChanged() {
        this.updateIntermediates = true;
    }

    @Override
    protected void ratesChanged() {
        this.updateIntermediates = true;
    }

    private void calculateIntermediates() {
        this.calculateFreqRY();
        double d = this.getKappa1();
        double d2 = this.getKappa2();
        if (d == 1.0) {
            d += 1.0E-10;
        }
        if (d2 == 1.0) {
            d2 += 1.0E-10;
        }
        double d3 = d * d * this.freqR + d * (2.0 * this.freqY - 1.0) - this.freqY;
        double d4 = d2 * d2 * this.freqY + d2 * (2.0 * this.freqR - 1.0) - this.freqR;
        this.p1a = this.freqG * d3;
        this.p0a = this.freqA * d3;
        this.p3b = this.freqT * d4;
        this.p2b = this.freqC * d4;
        this.a = -(d * this.freqR + this.freqY);
        this.b = -(d2 * this.freqY + this.freqR);
        this.p1aa = this.p1a / this.a;
        this.p0aa = this.p0a / this.a;
        this.p3bb = this.p3b / this.b;
        this.p2bb = this.p2b / this.b;
        this.p1aIsa = this.p1a / (1.0 + this.a);
        this.p0aIsa = this.p0a / (1.0 + this.a);
        this.p3bIsb = this.p3b / (1.0 + this.b);
        this.p2bIsb = this.p2b / (1.0 + this.b);
        this.k1g = d * this.freqG;
        this.k1a = d * this.freqA;
        this.k2t = d2 * this.freqT;
        this.k2c = d2 * this.freqC;
        this.subrateScale = 2.0 * (d * this.freqA * this.freqG + d2 * this.freqC * this.freqT + this.freqR * this.freqY);
        this.updateIntermediates = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getTransitionProbabilities(double d, double[] dArray) {
        Object object = this;
        synchronized (object) {
            if (this.updateIntermediates) {
                this.calculateIntermediates();
            }
        }
        d /= this.subrateScale;
        object = new double[]{0.0, this.k1g, this.freqC, this.freqT, this.k1a, 0.0, this.freqC, this.freqT, this.freqA, this.freqG, 0.0, this.k2t, this.freqA, this.freqG, this.k2c, 0.0};
        object[0] = -(object[1] + object[2] + object[3]);
        object[5] = -(object[4] + object[6] + object[7]);
        object[10] = -(object[8] + object[9] + object[11]);
        object[15] = -(object[12] + object[13] + object[14]);
        double[] dArray2 = new double[]{1.0 + object[0] - this.p1aa, (double)(object[1] + this.p1aa), (double)object[2], (double)object[3], (double)(object[4] + this.p0aa), 1.0 + object[5] - this.p0aa, (double)object[6], (double)object[7], (double)object[8], (double)object[9], 1.0 + object[10] - this.p3bb, (double)(object[11] + this.p3bb), (double)object[12], (double)object[13], (double)(object[14] + this.p2bb), 1.0 + object[15] - this.p2bb};
        double[] dArray3 = new double[]{(double)(-object[0] + this.p1aIsa), (double)(-object[1] - this.p1aIsa), (double)(-object[2]), (double)(-object[3]), (double)(-object[4] - this.p0aIsa), (double)(-object[5] + this.p0aIsa), (double)(-object[6]), (double)(-object[7]), (double)(-object[8]), (double)(-object[9]), (double)(-object[10] + this.p3bIsb), (double)(-object[11] - this.p3bIsb), (double)(-object[12]), (double)(-object[13]), (double)(-object[14] - this.p2bIsb), (double)(-object[15] + this.p2bIsb)};
        double d2 = Math.exp(-d);
        for (int i = 0; i < 16; ++i) {
            dArray3[i] = dArray3[i] * d2 + dArray2[i];
        }
        double d3 = Math.exp(d * this.a);
        double d4 = Math.exp(d * this.b);
        double d5 = d3 / (this.a * (1.0 + this.a));
        double d6 = d4 / (this.b * (1.0 + this.b));
        double d7 = this.p1a * d5;
        double d8 = this.p0a * d5;
        double d9 = this.p3b * d6;
        double d10 = this.p2b * d6;
        dArray3[0] = dArray3[0] + d7;
        dArray3[1] = dArray3[1] - d7;
        dArray3[4] = dArray3[4] - d8;
        dArray3[5] = dArray3[5] + d8;
        dArray3[10] = dArray3[10] + d9;
        dArray3[11] = dArray3[11] - d9;
        dArray3[14] = dArray3[14] - d10;
        dArray3[15] = dArray3[15] + d10;
        dArray[0] = dArray3[0];
        dArray[1] = dArray3[2];
        dArray[2] = dArray3[1];
        dArray[3] = dArray3[3];
        dArray[4] = dArray3[8];
        dArray[5] = dArray3[10];
        dArray[6] = dArray3[9];
        dArray[7] = dArray3[11];
        dArray[8] = dArray3[4];
        dArray[9] = dArray3[6];
        dArray[10] = dArray3[5];
        dArray[11] = dArray3[7];
        dArray[12] = dArray3[12];
        dArray[13] = dArray3[14];
        dArray[14] = dArray3[13];
        dArray[15] = dArray3[15];
    }

    @Override
    public void setupMatrix() {
    }

    @Override
    protected void setupRelativeRates() {
    }

    @Override
    public void restoreState() {
        super.restoreState();
        this.updateIntermediates = true;
    }

    public String toXHTML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<em>TN93 Model</em>");
        stringBuffer.append(" (kappa = ");
        stringBuffer.append(this.getKappa1()).append(",").append(this.getKappa2());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.SUBSTITUTION_MODELS;
    }

    @Override
    public String getDescription() {
        return "Tamura-Nei nucleotide substitution model";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(CITATION);
    }
}

