/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.AbstractPackMatrix;
import no.uib.cipr.matrix.BLASkernel;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Interface;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixNotSPDException;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.Vector;

abstract class AbstractSymmPackMatrix
extends AbstractPackMatrix {
    private BLASkernel.UpLo uplo;

    AbstractSymmPackMatrix(int n, BLASkernel.UpLo uplo) {
        super(n);
        this.uplo = uplo;
    }

    AbstractSymmPackMatrix(Matrix A, BLASkernel.UpLo uplo) {
        this(A, true, uplo);
    }

    AbstractSymmPackMatrix(Matrix A, boolean deep, BLASkernel.UpLo uplo) {
        super(A, deep);
        this.uplo = uplo;
    }

    public Vector multAdd(double alpha, Vector x, Vector y) {
        if (!(x instanceof DenseVector) || !(y instanceof DenseVector)) {
            return super.multAdd(alpha, x, y);
        }
        this.checkMultAdd(x, y);
        double[] xd = ((DenseVector)x).getData();
        double[] yd = ((DenseVector)y).getData();
        Interface.blas().spmv(this.uplo, this.numRows, alpha, this.data, xd, 1.0, yd);
        return y;
    }

    public Vector transMultAdd(double alpha, Vector x, Vector y) {
        return this.multAdd(alpha, x, y);
    }

    public Matrix rank1(double alpha, Vector x, Vector y) {
        if (x != y) {
            throw new IllegalArgumentException("x != y");
        }
        if (!(x instanceof DenseVector)) {
            return super.rank1(alpha, x, y);
        }
        this.checkRank1(x, y);
        double[] xd = ((DenseVector)x).getData();
        Interface.blas().spr(this.uplo, this.numRows, alpha, xd, this.data);
        return this;
    }

    public Matrix rank2(double alpha, Vector x, Vector y) {
        if (!(x instanceof DenseVector) || !(y instanceof DenseVector)) {
            return super.rank2(alpha, x, y);
        }
        this.checkRank2(x, y);
        double[] xd = ((DenseVector)x).getData();
        double[] yd = ((DenseVector)y).getData();
        Interface.blas().spr2(this.uplo, this.numRows, alpha, xd, yd, this.data);
        return this;
    }

    public Matrix solve(Matrix B, Matrix X) {
        if (!(X instanceof DenseMatrix)) {
            throw new UnsupportedOperationException("X must be a DenseMatrix");
        }
        this.checkSolve(B, X);
        double[] Xd = ((DenseMatrix)X).getData();
        X.set(B);
        int[] ipiv = new int[this.numRows];
        int info = Interface.lapack().spsv(this.uplo, this.numRows, X.numColumns(), (double[])this.data.clone(), ipiv, Xd);
        if (info > 0) {
            throw new MatrixSingularException();
        }
        if (info < 0) {
            throw new IllegalArgumentException();
        }
        return X;
    }

    public Vector solve(Vector b, Vector x) {
        DenseMatrix B = new DenseMatrix(b, false);
        DenseMatrix X = new DenseMatrix(x, false);
        this.solve(B, X);
        return x;
    }

    public Matrix transSolve(Matrix B, Matrix X) {
        return this.solve(B, X);
    }

    public Vector transSolve(Vector b, Vector x) {
        return this.solve(b, x);
    }

    Matrix SPDsolve(Matrix B, Matrix X) {
        if (!(X instanceof DenseMatrix)) {
            throw new UnsupportedOperationException("X must be a DenseMatrix");
        }
        this.checkSolve(B, X);
        double[] Xd = ((DenseMatrix)X).getData();
        X.set(B);
        int info = Interface.lapack().ppsv(this.uplo, this.numRows, X.numColumns(), (double[])this.data.clone(), Xd);
        if (info > 0) {
            throw new MatrixNotSPDException();
        }
        if (info < 0) {
            throw new IllegalArgumentException();
        }
        return X;
    }

    public Matrix transpose() {
        return this;
    }
}

