/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.data;

import org.ejml.data.MatrixIterator64F;
import org.ejml.data.RealMatrix64F;
import org.ejml.data.ReshapeMatrix;

public abstract class D1Matrix64F
implements ReshapeMatrix,
RealMatrix64F {
    public double[] data;
    public int numRows;
    public int numCols;

    public double[] getData() {
        return this.data;
    }

    public void setData(double[] data) {
        this.data = data;
    }

    public abstract int getIndex(int var1, int var2);

    public void set(D1Matrix64F b) {
        this.reshape(b.numRows, b.numCols);
        int dataLength = b.getNumElements();
        System.arraycopy(b.data, 0, this.data, 0, dataLength);
    }

    public double get(int index) {
        return this.data[index];
    }

    public double set(int index, double val) {
        this.data[index] = val;
        return this.data[index];
    }

    public double plus(int index, double val) {
        int n = index;
        double d = this.data[n] + val;
        this.data[n] = d;
        return d;
    }

    public double minus(int index, double val) {
        int n = index;
        double d = this.data[n] - val;
        this.data[n] = d;
        return d;
    }

    public double times(int index, double val) {
        int n = index;
        double d = this.data[n] * val;
        this.data[n] = d;
        return d;
    }

    public double div(int index, double val) {
        int n = index;
        double d = this.data[n] / val;
        this.data[n] = d;
        return d;
    }

    public abstract void reshape(int var1, int var2, boolean var3);

    @Override
    public void reshape(int numRows, int numCols) {
        this.reshape(numRows, numCols, false);
    }

    public MatrixIterator64F iterator(boolean rowMajor, int minRow, int minCol, int maxRow, int maxCol) {
        return new MatrixIterator64F(this, rowMajor, minRow, minCol, maxRow, maxCol);
    }

    @Override
    public int getNumRows() {
        return this.numRows;
    }

    @Override
    public int getNumCols() {
        return this.numCols;
    }

    public void setNumRows(int numRows) {
        this.numRows = numRows;
    }

    public void setNumCols(int numCols) {
        this.numCols = numCols;
    }
}

