library(CARMS)

SaGyro<-carms.make(title="Gyro Failure   Simulation", diagram_grid=c(11,12) )
SaGyro<-carms.state(SaGyro, prob=1, name="All Operating",size=2.2,h2w=2.3,  position=c(2,6))
SaGyro<-carms.state(SaGyro, prob=0, name="1 gyro, full",size=4.5,  h2w=.4, position=c(4,3))
SaGyro<-carms.state(SaGyro, prob=0, name="2 gyros, full",size=4.5,  h2w=.4, position=c(4,9))
SaGyro<-carms.state(SaGyro, prob=0, name="1 gyro, full",size=4.5,  h2w=.4, position=c(6,6))
SaGyro<-carms.state(SaGyro, prob=0, name="1 gyro, full",size=4.5,  h2w=.4, position=c(8,3))
SaGyro<-carms.state(SaGyro, prob=0, name="1 gyro, half",size=4.5,  h2w=.4, position=c(8,9))
SaGyro<-carms.state(SaGyro, prob=0, name="failed state",size=3, h2w=1.7, position=c(11,6))

# carms.base(x, value, base_label=NULL, description="")
SaGyro<-carms.base(SaGyro, 5e-2, time_units= "thousand Hours", base_label="B1", description="gyro failure")
SaGyro<-carms.base(SaGyro, 1e-1, base_label="B3", description="monitor disable")

# carms.arrow<-(x, from, to, rate, arc=0.35, arrow.position=0.5, label="")
SaGyro<-carms.arrow(SaGyro, 1, 2, rate="2*B1", label="2*B1", arc=.2)
SaGyro<-carms.arrow(SaGyro, 1, 3, rate= "B2", label="B2", arc= -.2)
SaGyro<-carms.arrow(SaGyro, 1, 4, rate="B3", label="B3", arc=.3)
SaGyro<-carms.arrow(SaGyro, 2, 5, rate="B2", label="B2", arc= .2)
SaGyro<-carms.arrow(SaGyro, 2, 7, rate= "B1+B3", label="B1+B3",arc=-.1)
SaGyro<-carms.arrow(SaGyro, 3, 6, rate= "2*B1", label="2*B1", arc=.1)
SaGyro<-carms.arrow(SaGyro, 4, 7, rate="B1", label="B1", arc=-.1)
SaGyro<-carms.arrow(SaGyro, 5, 7, rate= "B1", label="B1", arc=.2)
SaGyro<-carms.arrow(SaGyro, 6, 7, rate="B1", label="B1", arc=-.3)
dev.new(width=15, height=8, unit="in")
diagram.carms(SaGyro, shadow=FALSE, rate.text.y.shift=0.7 )

# usage: simulate.carms(x, solution, mission_time, intervals=50, cycles=2000)
SaGyro<-simulate.carms(SaGyro, "bd", 20, 50)
plot.carms(SaGyro)
