/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.circe.cohortdefinition.printfriendly;

import com.fasterxml.jackson.core.type.TypeReference;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.DefaultObjectWrapperBuilder;
import freemarker.template.TemplateModel;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import org.ohdsi.analysis.Utils;
import org.ohdsi.circe.cohortdefinition.CohortExpression;
import org.ohdsi.circe.cohortdefinition.ConceptSet;

public class MarkdownRender {
    private static Configuration cfg;
    private static DefaultObjectWrapper objectWrapper;

    public String renderCohort(CohortExpression expression) {
        try {
            TemplateModel dataModel = objectWrapper.wrap((Object)expression);
            StringWriter out = new StringWriter();
            cfg.getTemplate("cohortExpression.ftl").process((Object)dataModel, (Writer)out);
            return ((Object)out).toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String renderCohort(String expressionJson) {
        CohortExpression expression = CohortExpression.fromJson(expressionJson);
        return this.renderCohort(expression);
    }

    public String renderConceptSetList(ConceptSet[] conceptSetList) {
        try {
            HashMap<String, ConceptSet[]> root = new HashMap<String, ConceptSet[]>();
            root.put("conceptSets", conceptSetList);
            TemplateModel dataModel = objectWrapper.wrap(root);
            StringWriter out = new StringWriter();
            cfg.getTemplate("conceptSet.ftl").process((Object)dataModel, (Writer)out);
            return ((Object)out).toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String renderConceptSetList(String conceptSetListJson) {
        ConceptSet[] conceptSetList = (ConceptSet[])Utils.deserialize((String)conceptSetListJson, (TypeReference)new TypeReference<ConceptSet[]>(){});
        return this.renderConceptSetList(conceptSetList);
    }

    public String renderConceptSet(ConceptSet conceptSet) {
        ConceptSet[] conceptSetList = new ConceptSet[]{conceptSet};
        return this.renderConceptSetList(conceptSetList);
    }

    public String renderConceptSet(String conceptSetJson) {
        ConceptSet conceptSet = (ConceptSet)Utils.deserialize((String)conceptSetJson, (TypeReference)new TypeReference<ConceptSet>(){});
        return this.renderConceptSet(conceptSet);
    }

    static {
        try {
            cfg = new Configuration(Configuration.VERSION_2_3_30);
            cfg.setClassForTemplateLoading(MarkdownRender.class, "/resources/cohortdefinition/printfriendly");
            cfg.setAPIBuiltinEnabled(true);
            cfg.setBooleanFormat("true, false");
            DefaultObjectWrapperBuilder builder = new DefaultObjectWrapperBuilder(Configuration.VERSION_2_3_27);
            builder.setExposeFields(true);
            objectWrapper = builder.build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

