/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Generation.LVQ;

import java.util.ArrayList;
import keel.Algorithms.Instance_Generation.Basic.Prototype;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerationAlgorithm;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerator;
import keel.Algorithms.Instance_Generation.Basic.PrototypeSet;
import keel.Algorithms.Instance_Generation.BasicMethods.CNN;
import keel.Algorithms.Instance_Generation.LVQ.LVQ1;
import keel.Algorithms.Instance_Generation.LVQ.LVQ2_1;
import keel.Algorithms.Instance_Generation.utilities.KNN.KNN;
import keel.Algorithms.Instance_Generation.utilities.Parameters;

public class LVQPRU
extends PrototypeGenerator {
    protected static int MINIMUM_CLASS_SET_SIZE = 2;
    protected double percentageOfPrototypesPerClass = 10.0;
    protected double percentageOfPrototypes = 10.0;
    protected int numberOfPrototypes = 10;
    protected int numberOfIterations = 1000;
    protected double windowWidth = 0.1;
    protected int numberOfIterationsLVQ2_1 = 10;
    protected double alpha_0 = 0.01;
    protected int k = 2;

    private PrototypeSet makeInitialReductionPerClass(PrototypeSet set) {
        if (set.size() <= 2) {
            PrototypeSet result = new PrototypeSet();
            result.add(set.avg());
            return result;
        }
        int nP = LVQPRU.getSetSizeFromPercentage(set, this.percentageOfPrototypesPerClass);
        nP = Math.max(nP, MINIMUM_CLASS_SET_SIZE);
        LVQ1 lvq1 = new LVQ1(set, this.numberOfIterations, nP, this.alpha_0);
        PrototypeSet reducedByLVQ1 = lvq1.reduceSet();
        return reducedByLVQ1;
    }

    private PrototypeSet makeLVQ2_1Reduction(PrototypeSet set) {
        if (set.size() < 2) {
            PrototypeSet result = new PrototypeSet();
            result.add(set.avg());
            return result;
        }
        int numP = Math.min(set.size(), this.numberOfPrototypes);
        LVQ2_1 lvq2_1 = new LVQ2_1(set, this.numberOfIterations, numP, this.alpha_0, this.windowWidth);
        PrototypeSet reducedByLVQ2_1 = lvq2_1.reduceSet();
        return reducedByLVQ2_1;
    }

    public LVQPRU(PrototypeSet _trainingDataSet, Parameters parameters) {
        super(_trainingDataSet, parameters);
        this.algorithmName = "LVQPRU";
        this.numberOfIterations = parameters.getNextAsInt();
        this.percentageOfPrototypesPerClass = parameters.getNextAsDouble();
        this.percentageOfPrototypes = parameters.getNextAsDouble();
        this.numberOfPrototypes = this.getSetSizeFromPercentage(this.percentageOfPrototypes);
        this.numberOfIterationsLVQ2_1 = parameters.getNextAsInt();
        this.alpha_0 = parameters.getNextAsDouble();
        this.windowWidth = parameters.getNextAsDouble();
        this.k = parameters.getNextAsInt();
    }

    public LVQPRU(PrototypeSet _trainingDataSet, int numIter, double pcNpc, double pcN, int numIterLVQ2_1, double a, double w, int k) {
        super(_trainingDataSet);
        this.numberOfIterations = numIter;
        this.percentageOfPrototypesPerClass = pcNpc;
        this.percentageOfPrototypes = pcN;
        this.numberOfIterationsLVQ2_1 = numIterLVQ2_1;
        this.alpha_0 = a;
        this.windowWidth = w;
        this.algorithmName = "LVQPRU";
        this.k = k;
    }

    protected static int indexOfMinElement(ArrayList<Double> array) {
        double min = array.get(0);
        int minIndex = 0;
        int i = 0;
        for (double d : array) {
            if (d < min) {
                min = d;
                minIndex = i;
            }
            ++i;
        }
        return minIndex;
    }

    @Override
    public PrototypeSet reduceSet() {
        PrototypeSet T = this.trainingDataSet.copy();
        ArrayList<PrototypeSet> parts = T.classPartition();
        ArrayList<PrototypeSet> reducedParts = new ArrayList<PrototypeSet>();
        for (PrototypeSet ps : parts) {
            PrototypeSet LVQ1reduced = this.makeInitialReductionPerClass(ps);
            reducedParts.add(LVQ1reduced);
        }
        PrototypeSet R = new PrototypeSet(reducedParts);
        PrototypeSet newR = new PrototypeSet();
        for (Prototype p : R) {
            PrototypeSet nn = KNN.getNearestNeighbors(p, this.trainingDataSet, this.k);
            PrototypeSet nnWithSameClass = nn.getFromClass(p.label());
            if (nnWithSameClass.size() > 0) {
                newR.add(p);
                continue;
            }
            if (nn.size() <= 0) continue;
            double newClass = nn.mostFrequentClass();
            p.setClass(newClass);
            newR.add(p);
        }
        R = newR;
        R = this.makeLVQ2_1Reduction(R);
        CNN.makeReductionOf(R);
        boolean end = false;
        int acc = LVQPRU.absoluteAccuracy(R, this.trainingDataSet);
        ArrayList<Double> E = new ArrayList<Double>(R.size());
        int R_size = R.size();
        for (int i = 0; i < R_size; ++i) {
            E.add(0.0);
        }
        int index = 0;
        for (Prototype p : R) {
            p.setIndex(index++);
        }
        int iterations = 0;
        do {
            for (Prototype p : R) {
                PrototypeSet nn = KNN.getNearestNeighbors(p, R, 2);
                double l = ((Prototype)nn.get(0)).label();
                double m = ((Prototype)nn.get(1)).label();
                double n = p.label();
                int i = ((Prototype)nn.get(0)).getIndex();
                if (n == l && n != m) {
                    E.set(i, E.get(i) + 1.0);
                }
                if (n != l && n == m) {
                    E.set(i, E.get(i) - 1.0);
                }
                ++i;
            }
            int iE = LVQPRU.indexOfMinElement(E);
            Prototype erroneus = (Prototype)R.get(iE);
            R.remove(iE);
            int currAcc = LVQPRU.absoluteAccuracy(R, this.trainingDataSet);
            boolean bl = end = currAcc < acc;
            if (!end) {
                acc = currAcc;
                R = this.makeLVQ2_1Reduction(R);
                continue;
            }
            R.add(erroneus);
        } while (!end && ++iterations > this.numberOfIterations);
        return R;
    }

    public static void main(String[] args) {
        Parameters.setUse("LVQPRU", "<seed> <number of iterations> <percentage of prots. by class> <percentage of prots> <number of iterations LVQ2_1> <WindowWidth> <alpha_0> <k (of KNN)>");
        Parameters.assertBasicArgs(args);
        PrototypeSet training = PrototypeGenerationAlgorithm.readPrototypeSet(args[0]);
        PrototypeSet test = PrototypeGenerationAlgorithm.readPrototypeSet(args[1]);
        long seed = Parameters.assertExtendedArgAsInt(args, 2, "seed", 0.0, 9.223372036854776E18);
        LVQPRU.setSeed(seed);
        int numIter = Parameters.assertExtendedArgAsInt(args, 3, "iterations of optimal-LVQ3 reduction", 1.0, 2.147483647E9);
        double pcNpc = Parameters.assertExtendedArgAsDouble(args, 4, "percentage of number of prototypes per class", 0.0, 100.0);
        double pcN = Parameters.assertExtendedArgAsDouble(args, 5, "percentage of number of prototypes", 0.0, 100.0);
        int numIterLVQ2_1 = Parameters.assertExtendedArgAsInt(args, 6, "iterations of LVQ2.1 reduction", 1.0, 2.147483647E9);
        double a = Parameters.assertExtendedArgAsDouble(args, 7, "alpha0 parameter of the LVQ2.1 internal reduction", 0.0, 1.0);
        double w = Parameters.assertExtendedArgAsDouble(args, 8, "window width parameter of the LVQ2.1 internal reduction", 0.0, 1.0);
        int k = Parameters.assertExtendedArgAsInt(args, 9, "size of neighborhood of KNN", 1.0, 3.0);
        LVQPRU generator = new LVQPRU(training, numIter, pcNpc, pcN, numIterLVQ2_1, a, w, k);
        PrototypeSet resultingSet = generator.execute();
        int accuracy1NN = KNN.classficationAccuracy(resultingSet, test);
        generator.showResultsOfAccuracy(Parameters.getFileName(), accuracy1NN, test);
    }
}

