/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Fuzzy_Rule_Learning.Shared.Fuzzy;

import keel.Algorithms.Fuzzy_Rule_Learning.Shared.Fuzzy.Fuzzy;
import keel.Algorithms.Fuzzy_Rule_Learning.Shared.Fuzzy.FuzzyInterval;

public class FuzzyNumberTRIANG
extends Fuzzy {
    double left;
    double center;
    double right;

    public FuzzyNumberTRIANG(double l, double c, double r) {
        this.left = l;
        this.center = c;
        this.right = r;
    }

    public FuzzyNumberTRIANG(FuzzyNumberTRIANG t) {
        this.left = t.left;
        this.center = t.center;
        this.right = t.right;
    }

    public void Asigna(FuzzyNumberTRIANG t) {
        this.left = t.left;
        this.center = t.center;
        this.right = t.right;
    }

    @Override
    public boolean equals(Fuzzy b) {
        if (!(b instanceof FuzzyNumberTRIANG)) {
            return false;
        }
        FuzzyNumberTRIANG bt = (FuzzyNumberTRIANG)b;
        if (this.left != bt.left) {
            return false;
        }
        if (this.center != bt.center) {
            return false;
        }
        return this.right == bt.right;
    }

    @Override
    public Fuzzy clone() {
        return new FuzzyNumberTRIANG(this);
    }

    @Override
    public double evaluateMembership(double x) {
        if (x < this.left) {
            return 0.0;
        }
        if (x < this.center) {
            return 1.0 - (this.center - x) / (this.center - this.left);
        }
        if (x < this.right) {
            return (this.right - x) / (this.right - this.center);
        }
        return 0.0;
    }

    @Override
    public double massCentre() {
        return this.center;
    }

    @Override
    public FuzzyInterval support() {
        return new FuzzyInterval(this.left, this.right);
    }

    @Override
    public String aString() {
        return "TRIAN(" + this.left + "," + this.center + "," + this.right + ")";
    }
}

