/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.syntaxtree;

import net.sf.jclec.IConfigure;
import net.sf.jclec.ISpecies;
import net.sf.jclec.base.AbstractMutator;
import net.sf.jclec.syntaxtree.ISyntaxTreeSpecies;
import net.sf.jclec.syntaxtree.SyntaxTree;
import net.sf.jclec.syntaxtree.SyntaxTreeIndividual;
import org.apache.commons.configuration.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SyntaxTreeMutator<I extends SyntaxTreeIndividual>
extends AbstractMutator<I>
implements IConfigure {
    protected int targetTreeIndex = -1;
    protected transient ISyntaxTreeSpecies<I> species;
    protected transient ISyntaxTreeSpecies.ISyntaxTreeSchema[] schema;

    public int getTargetTreeIndex() {
        return this.targetTreeIndex;
    }

    public void setTargetTreeIndex(int targetTreeIndex) {
        this.targetTreeIndex = targetTreeIndex;
    }

    @Override
    public void configure(Configuration settings) {
        int targetTreeIndex = settings.getInt("target-tree-index", -1);
        this.setTargetTreeIndex(targetTreeIndex);
    }

    @Override
    protected void prepareMutation() {
        ISpecies species = this.context.getSpecies();
        if (!(species instanceof ISyntaxTreeSpecies)) {
            throw new IllegalStateException("Invalid species in context");
        }
        this.species = (ISyntaxTreeSpecies)species;
        this.schema = this.species.getGenotypeSchema();
    }

    @Override
    protected void mutateNext() {
        int nOfSyntaxTrees = this.species.getNumberOfSyntaxTrees();
        int actTargetTreeIndex = this.targetTreeIndex == -1 ? this.randgen.choose(0, nOfSyntaxTrees) : this.targetTreeIndex;
        SyntaxTree[] parentGenotype = (SyntaxTree[])((SyntaxTreeIndividual)this.parentsBuffer.get(this.parentsCounter)).getGenotype();
        SyntaxTree[] sonGenotype = new SyntaxTree[nOfSyntaxTrees];
        int i = 0;
        while (i < nOfSyntaxTrees) {
            sonGenotype[i] = i == actTargetTreeIndex ? this.mutateTree(parentGenotype[i], this.schema[i]) : parentGenotype[i].copy();
            ++i;
        }
        this.sonsBuffer.add(this.species.createIndividual(sonGenotype));
    }

    protected abstract SyntaxTree mutateTree(SyntaxTree var1, ISyntaxTreeSpecies.ISyntaxTreeSchema var2);
}

