/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.model.managers.constraints.global;

import choco.cp.model.managers.IntConstraintManager;
import choco.cp.solver.CPSolver;
import choco.cp.solver.constraints.global.regular.Regular;
import choco.kernel.common.Constant;
import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.model.ModelException;
import choco.kernel.model.constraints.automaton.DFA;
import choco.kernel.model.constraints.automaton.Transition;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public final class RegularManager
extends IntConstraintManager {
    private int nID;

    public SConstraint makeConstraint(Solver solver, IntegerVariable[] vars, Object parameters, List<String> options) {
        if (solver instanceof CPSolver) {
            IntDomainVar[] variables = solver.getVar(vars);
            if (parameters instanceof int[][]) {
                int[] coefs = ((int[][])parameters)[0];
                int value = ((int[][])parameters)[1][0];
                return this.knapsack(solver, vars, value, coefs);
            }
            if (parameters instanceof Object[]) {
                Object[] params = (Object[])parameters;
                return new Regular(new DFA((List)params[0], (int[])params[1], (int[])params[2]), variables, solver.getEnvironment());
            }
            if (parameters instanceof List) {
                return new Regular(new DFA((List)parameters), variables, solver.getEnvironment());
            }
            if (parameters instanceof DFA) {
                return new Regular((DFA)parameters, variables, solver.getEnvironment());
            }
            if (parameters instanceof String) {
                return new Regular(new DFA((String)parameters, vars.length), variables, solver.getEnvironment());
            }
        }
        throw new ModelException("Could not found a constraint manager in " + this.getClass() + " !");
    }

    @Override
    public int[] getFavoriteDomains(List<String> options) {
        return new int[]{0, 2, 3};
    }

    public SConstraint knapsack(Solver s, IntegerVariable[] vars, int goal, int[] coeffs) {
        int i;
        int i2;
        boolean tuples = false;
        int n = coeffs.length;
        if (goal < 0) {
            tuples = true;
        }
        for (int i3 = 0; !tuples && i3 < n; ++i3) {
            if (coeffs[i3] >= 0 && vars[i3].getLowB() * coeffs[i3] >= 0 && vars[i3].getUppB() * coeffs[i3] >= 0) continue;
            tuples = true;
        }
        if (tuples) {
            ArrayList<int[]> ts = new ArrayList<int[]>();
            this.explore(0, 0, new int[vars.length], vars, coeffs, goal, ts);
            if (ts.size() == 0) {
                return Constant.FALSE;
            }
            DFA dfa = new DFA(ts);
            return new Regular(dfa, s.getVar(vars), s.getEnvironment());
        }
        int[] temp = new int[coeffs.length + 1];
        System.arraycopy(coeffs, 0, temp, 1, coeffs.length);
        temp[0] = 0;
        coeffs = temp;
        int[][] P = new int[coeffs.length][goal + 1];
        int[][] G = new int[coeffs.length][goal + 1];
        for (i2 = 0; i2 < P.length; ++i2) {
            for (int j = 0; j < P[0].length; ++j) {
                G[i2][j] = 0;
                P[i2][j] = 0;
            }
        }
        P[0][0] = 1;
        for (i2 = 1; i2 < P.length; ++i2) {
            for (int b = 0; b < goal + 1; ++b) {
                if (P[i2 - 1][b] != 1) continue;
                DisposableIntIterator it = vars[i2 - 1].getDomainIterator();
                while (it.hasNext()) {
                    int value = it.next();
                    if (b + coeffs[i2] * value > goal) continue;
                    P[i2][b + coeffs[i2] * value] = 1;
                }
                it.dispose();
            }
        }
        boolean sat = false;
        for (i = goal; i >= goal; --i) {
            sat |= P[P.length - 1][goal] == 1;
        }
        G[G.length - 1][goal] = 1;
        if (sat) {
            int i4;
            for (i = G.length - 2; i >= 0; --i) {
                for (int b = 0; b < G[0].length; ++b) {
                    if (G[i + 1][b] != 1) continue;
                    DisposableIntIterator it = vars[i].getDomainIterator();
                    while (it.hasNext()) {
                        int x = it.next();
                        if (b - coeffs[i + 1] * x < 0 || P[i][b - coeffs[i + 1] * x] != 1) continue;
                        G[i][b - coeffs[i + 1] * x] = 1;
                    }
                    it.dispose();
                }
            }
            LinkedList<Transition> t = new LinkedList<Transition>();
            LinkedList<Integer> ints = new LinkedList<Integer>();
            this.nID = 0;
            int[][] labels = new int[coeffs.length][goal + 1];
            for (i4 = 0; i4 < labels.length; ++i4) {
                Arrays.fill(labels[i4], -1);
            }
            this.generateTransitionList(0, 0, t, labels, coeffs, G, vars);
            for (i4 = 0; i4 <= 0; ++i4) {
                ints.add(G.length + i4 - 1);
            }
            DFA dfa = new DFA(t, ints, (Integer)ints.get(0));
            return new Regular(dfa, s.getVar(vars), s.getEnvironment());
        }
        return Constant.FALSE;
    }

    private void explore(int vidx, int sum, int[] path, IntegerVariable[] vars, int[] coeffs, int goal, List<int[]> ts) {
        if (vidx == vars.length) {
            if (sum == goal) {
                ts.add((int[])path.clone());
            }
            return;
        }
        DisposableIntIterator it = vars[vidx].getDomainIterator();
        while (it.hasNext()) {
            path[vidx] = it.next();
            this.explore(vidx + 1, sum + coeffs[vidx] * path[vidx], path, vars, coeffs, goal, ts);
        }
        it.dispose();
    }

    private void generateTransitionList(int x, int y, List<Transition> t, int[][] labels, int[] A, int[][] G, IntegerVariable[] bools) {
        if (x >= G.length - 1) {
            return;
        }
        int[] vars = bools[x].getValues();
        if (vars == null) {
            for (int var = bools[x].getLowB(); var <= bools[x].getUppB(); ++var) {
                if (y + A[x + 1] * var >= G[0].length || G[x + 1][y + A[x + 1] * var] != 1) continue;
                if (labels[x][y] == -1) {
                    labels[x][y] = this.nID++;
                }
                if (labels[x + 1][y + A[x + 1] * var] == -1) {
                    labels[x + 1][y + A[x + 1] * var] = this.nID++;
                }
                t.add(new Transition(labels[x][y], var, labels[x + 1][y + A[x + 1] * var]));
                this.generateTransitionList(x + 1, y + A[x + 1] * var, t, labels, A, G, bools);
            }
        } else {
            for (int var = 0; var < vars.length; ++var) {
                if (y + A[x + 1] * vars[var] >= G[0].length || G[x + 1][y + A[x + 1] * vars[var]] != 1) continue;
                if (labels[x][y] == -1) {
                    labels[x][y] = this.nID++;
                }
                if (labels[x + 1][y + A[x + 1] * vars[var]] == -1) {
                    labels[x + 1][y + A[x + 1] * vars[var]] = this.nID++;
                }
                t.add(new Transition(labels[x][y], vars[var], labels[x + 1][y + A[x + 1] * vars[var]]));
                this.generateTransitionList(x + 1, y + A[x + 1] * vars[var], t, labels, A, G, bools);
            }
        }
    }
}

