% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tag-data.R
\name{tags_data}
\alias{tags_data}
\title{use ctags and gtags to parse call data}
\usage{
tags_data(path, has_tabs = NULL, pkg_name = NULL)
}
\arguments{
\item{path}{Path to local repository}

\item{has_tabs}{A logical flag indicating whether or not the code contains
any tab characters. This can be determined from \link{loc_stats}, which has a
\code{tabs} column. If not given, that value will be extracted from internally
calling that function.}

\item{pkg_name}{Only used for external_call_network, to label
package-internal calls.}
}
\description{
use ctags and gtags to parse call data
}
\examples{
\dontrun{
tarball <- "magrittr_2.0.1.tar.gz"
u <- paste0 (
    "https://cran.r-project.org/src/contrib/",
    tarball
)
f <- file.path (tempdir (), tarball)
download.file (u, f)
# have to extract tarball to call function on source code:
path <- extract_tarball (f)
tags <- tags_data (path)
}
}
\seealso{
Other tags: 
\code{\link{ctags_install}()},
\code{\link{ctags_test}()}
}
\concept{tags}
