/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.math;

import java.util.Random;

public class RandomNumbersTool
extends Random {
    private static final long serialVersionUID = -8238833473383641882L;
    private static Random random;
    private static long randomSeed;

    public static void setRandom(Random base_random) {
        random = base_random;
    }

    public static void setRandomSeed(long new_seed) {
        randomSeed = new_seed;
        random.setSeed(randomSeed);
    }

    public static long getRandomSeed() {
        return randomSeed;
    }

    public static Random getRandom() {
        return random;
    }

    public static int randomInt() {
        return RandomNumbersTool.randomInt(0, 1);
    }

    public static int randomInt(int lo, int hi) {
        return lo + random.nextInt(1 + hi - lo);
    }

    public static long randomLong() {
        return RandomNumbersTool.randomLong(0L, 1L);
    }

    public static long randomLong(long lo, long hi) {
        return RandomNumbersTool.nextLong(random, hi - lo + 1L) + lo;
    }

    private static long nextLong(Random rng, long n) {
        long val;
        long bits;
        if (n <= 0L) {
            throw new IllegalArgumentException("n must be greater than 0");
        }
        while ((bits = rng.nextLong() << 1 >>> 1) - (val = bits % n) + (n - 1L) < 0L) {
        }
        return val;
    }

    public static float randomFloat() {
        return random.nextFloat();
    }

    public static float randomFloat(float lo, float hi) {
        return (hi - lo) * random.nextFloat() + lo;
    }

    public static double randomDouble() {
        return random.nextDouble();
    }

    public static double randomDouble(double lo, double hi) {
        return (hi - lo) * random.nextDouble() + lo;
    }

    public static boolean randomBoolean() {
        return RandomNumbersTool.randomInt() == 1;
    }

    public static int randomBit() {
        return RandomNumbersTool.randomInt();
    }

    public static boolean flipCoin(double p) {
        return RandomNumbersTool.randomDouble() < p;
    }

    public static float gaussianFloat(float dev) {
        return (float)random.nextGaussian() * dev;
    }

    public static double gaussianDouble(double dev) {
        return random.nextGaussian() * dev;
    }

    public static double exponentialDouble(double mean) {
        return -mean * Math.log(RandomNumbersTool.randomDouble());
    }

    static {
        randomSeed = System.currentTimeMillis();
        random = new Random(randomSeed);
    }
}

