/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.hash.stereo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.openscience.cdk.hash.stereo.BasicPermutationParity;
import org.openscience.cdk.hash.stereo.CombinedPermutationParity;
import org.openscience.cdk.hash.stereo.DoubleBond2DParity;
import org.openscience.cdk.hash.stereo.DoubleBond3DParity;
import org.openscience.cdk.hash.stereo.GeometricParity;
import org.openscience.cdk.hash.stereo.GeometryEncoder;
import org.openscience.cdk.hash.stereo.MultiStereoEncoder;
import org.openscience.cdk.hash.stereo.PermutationParity;
import org.openscience.cdk.hash.stereo.StereoEncoder;
import org.openscience.cdk.hash.stereo.StereoEncoderFactory;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;

public final class GeometricDoubleBondEncoderFactory
implements StereoEncoderFactory {
    @Override
    public StereoEncoder create(IAtomContainer container, int[][] graph) {
        ArrayList<StereoEncoder> encoders = new ArrayList<StereoEncoder>(5);
        for (IBond bond : container.bonds()) {
            StereoEncoder encoder;
            if (!IBond.Order.DOUBLE.equals((Object)bond.getOrder()) || IBond.Stereo.E_OR_Z.equals((Object)bond.getStereo())) continue;
            IAtom left = bond.getBegin();
            IAtom right = bond.getEnd();
            if (Integer.valueOf(7).equals(left.getAtomicNumber()) && Integer.valueOf(7).equals(right.getAtomicNumber()) || (encoder = GeometricDoubleBondEncoderFactory.newEncoder(container, left, right, right, left, graph)) == null) continue;
            encoders.add(encoder);
        }
        return encoders.isEmpty() ? StereoEncoder.EMPTY : new MultiStereoEncoder(encoders);
    }

    static StereoEncoder newEncoder(IAtomContainer container, IAtom left, IAtom leftParent, IAtom right, IAtom rightParent, int[][] graph) {
        List leftBonds = container.getConnectedBondsList(left);
        List rightBonds = container.getConnectedBondsList(right);
        if (GeometricDoubleBondEncoderFactory.accept(left, leftBonds) && GeometricDoubleBondEncoderFactory.accept(right, rightBonds)) {
            int r2;
            int[] rightNeighbors;
            int r1;
            int l2;
            int leftIndex = container.indexOf(left);
            int rightIndex = container.indexOf(right);
            int leftParentIndex = container.indexOf(leftParent);
            int rightParentIndex = container.indexOf(rightParent);
            int[] leftNeighbors = GeometricDoubleBondEncoderFactory.moveToBack(graph[leftIndex], leftParentIndex);
            int l1 = leftNeighbors[0];
            GeometricParity geometric = GeometricDoubleBondEncoderFactory.geometric(container, leftIndex, rightIndex, l1, l2 = leftNeighbors[1] == leftParentIndex ? leftIndex : leftNeighbors[1], r1 = (rightNeighbors = GeometricDoubleBondEncoderFactory.moveToBack(graph[rightIndex], rightParentIndex))[0], r2 = rightNeighbors[1] == rightParentIndex ? rightIndex : rightNeighbors[1]);
            if (geometric != null) {
                return new GeometryEncoder(new int[]{leftIndex, rightIndex}, (PermutationParity)new CombinedPermutationParity(GeometricDoubleBondEncoderFactory.permutation(leftNeighbors), GeometricDoubleBondEncoderFactory.permutation(rightNeighbors)), geometric);
            }
        }
        return null;
    }

    static GeometricParity geometric(IAtomContainer mol, int l, int r, int l1, int l2, int r1, int r2) {
        Point2d l2d = mol.getAtom(l).getPoint2d();
        Point2d r2d = mol.getAtom(r).getPoint2d();
        Point2d l12d = mol.getAtom(l1).getPoint2d();
        Point2d l22d = mol.getAtom(l2).getPoint2d();
        Point2d r12d = mol.getAtom(r1).getPoint2d();
        Point2d r22d = mol.getAtom(r2).getPoint2d();
        if (l2d != null && r2d != null && l12d != null && l22d != null && r12d != null && r22d != null) {
            return new DoubleBond2DParity(l2d, r2d, l12d, l22d, r12d, r22d);
        }
        Point3d l3d = mol.getAtom(l).getPoint3d();
        Point3d r3d = mol.getAtom(r).getPoint3d();
        Point3d l13d = mol.getAtom(l1).getPoint3d();
        Point3d r13d = mol.getAtom(r1).getPoint3d();
        if (l3d != null && r3d != null && l13d != null && r13d != null) {
            return new DoubleBond3DParity(l3d, r3d, l13d, r13d);
        }
        return null;
    }

    static PermutationParity permutation(int[] neighbors) {
        return neighbors.length == 2 ? PermutationParity.IDENTITY : new BasicPermutationParity(Arrays.copyOf(neighbors, neighbors.length - 1));
    }

    static int[] moveToBack(int[] neighbors, int v) {
        int j = 0;
        for (int i = 0; i < neighbors.length; ++i) {
            if (neighbors[i] == v) continue;
            neighbors[j++] = neighbors[i];
        }
        neighbors[neighbors.length - 1] = v;
        return neighbors;
    }

    static boolean accept(IAtom atom, List<IBond> bonds) {
        int dbCount = 0;
        if (!IAtomType.Hybridization.SP2.equals((Object)atom.getHybridization())) {
            return false;
        }
        if (bonds.size() == 1) {
            return false;
        }
        for (IBond bond : bonds) {
            IBond.Stereo stereo;
            if (IBond.Order.DOUBLE.equals((Object)bond.getOrder())) {
                ++dbCount;
            }
            if (!IBond.Stereo.UP_OR_DOWN.equals((Object)(stereo = bond.getStereo())) && !IBond.Stereo.UP_OR_DOWN_INVERTED.equals((Object)stereo)) continue;
            return false;
        }
        return dbCount == 1;
    }
}

