/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.manipulator;

import java.util.Iterator;
import org.openscience.cdk.formula.MolecularFormulaRange;
import org.openscience.cdk.interfaces.IElement;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.interfaces.IMolecularFormula;
import org.openscience.cdk.interfaces.IMolecularFormulaSet;
import org.openscience.cdk.tools.manipulator.MolecularFormulaManipulator;

public class MolecularFormulaSetManipulator {
    public static IMolecularFormula getMaxOccurrenceElements(IMolecularFormulaSet mfSet) {
        IMolecularFormula molecularFormula = (IMolecularFormula)mfSet.getBuilder().newInstance(IMolecularFormula.class, new Object[0]);
        for (IMolecularFormula mf : mfSet.molecularFormulas()) {
            for (IIsotope isotope : mf.isotopes()) {
                IElement element = (IElement)mfSet.getBuilder().newInstance(IElement.class, new Object[]{isotope});
                int occur_new = MolecularFormulaManipulator.getElementCount(mf, element);
                if (!MolecularFormulaManipulator.containsElement(molecularFormula, element)) {
                    molecularFormula.addIsotope((IIsotope)mfSet.getBuilder().newInstance(IIsotope.class, new Object[]{element}), occur_new);
                    continue;
                }
                int occur_old = MolecularFormulaManipulator.getElementCount(molecularFormula, element);
                if (occur_new <= occur_old) continue;
                MolecularFormulaManipulator.removeElement(molecularFormula, element);
                molecularFormula.addIsotope((IIsotope)mfSet.getBuilder().newInstance(IIsotope.class, new Object[]{element}), occur_new);
            }
        }
        return molecularFormula;
    }

    public static IMolecularFormula getMinOccurrenceElements(IMolecularFormulaSet mfSet) {
        IMolecularFormula molecularFormula = (IMolecularFormula)mfSet.getBuilder().newInstance(IMolecularFormula.class, new Object[0]);
        for (IMolecularFormula mf : mfSet.molecularFormulas()) {
            for (IIsotope isotope : mf.isotopes()) {
                IElement element = (IElement)mfSet.getBuilder().newInstance(IElement.class, new Object[]{isotope});
                int occur_new = MolecularFormulaManipulator.getElementCount(mf, element);
                if (!MolecularFormulaManipulator.containsElement(molecularFormula, element)) {
                    molecularFormula.addIsotope((IIsotope)mfSet.getBuilder().newInstance(IIsotope.class, new Object[]{element}), occur_new);
                    continue;
                }
                int occur_old = MolecularFormulaManipulator.getElementCount(molecularFormula, element);
                if (occur_new >= occur_old) continue;
                MolecularFormulaManipulator.removeElement(molecularFormula, element);
                molecularFormula.addIsotope((IIsotope)mfSet.getBuilder().newInstance(IIsotope.class, new Object[]{element}), occur_new);
            }
        }
        return molecularFormula;
    }

    public static IMolecularFormulaSet remove(IMolecularFormulaSet formulaSet, IMolecularFormula formulaMin, IMolecularFormula formulaMax) {
        if (!MolecularFormulaSetManipulator.validCorrelation(formulaMin, formulaMax)) {
            return null;
        }
        IMolecularFormulaSet newFormulaSet = (IMolecularFormulaSet)formulaSet.getBuilder().newInstance(IMolecularFormulaSet.class, new Object[0]);
        for (IMolecularFormula formula : formulaSet.molecularFormulas()) {
            boolean flagPass = true;
            if (!MolecularFormulaSetManipulator.validCorrelation(formula, formulaMin)) continue;
            for (IElement element : MolecularFormulaManipulator.elements(formulaMin)) {
                int occur = MolecularFormulaManipulator.getElementCount(formula, element);
                int occurMax = MolecularFormulaManipulator.getElementCount(formulaMax, element);
                int occurMin = MolecularFormulaManipulator.getElementCount(formulaMin, element);
                if (occurMin <= occur && occur <= occurMax) continue;
                flagPass = false;
                break;
            }
            if (!flagPass) continue;
            newFormulaSet.addMolecularFormula(formula);
        }
        return newFormulaSet;
    }

    private static boolean validCorrelation(IMolecularFormula formulaMin, IMolecularFormula formulamax) {
        for (IElement element : MolecularFormulaManipulator.elements(formulaMin)) {
            if (MolecularFormulaManipulator.containsElement(formulamax, element)) continue;
            return false;
        }
        return true;
    }

    public static boolean contains(IMolecularFormulaSet formulaSet, IMolecularFormula formula) {
        for (IMolecularFormula fm : formulaSet.molecularFormulas()) {
            if (!MolecularFormulaManipulator.compare(fm, formula)) continue;
            return true;
        }
        return false;
    }

    public static IMolecularFormulaSet remove(IMolecularFormulaSet formulaSet, MolecularFormulaRange formulaRange) {
        IMolecularFormulaSet newFormulaSet = (IMolecularFormulaSet)formulaSet.getBuilder().newInstance(IMolecularFormulaSet.class, new Object[0]);
        for (IMolecularFormula formula : formulaSet.molecularFormulas()) {
            boolean flagCorrect = true;
            Iterator<Object> itEle = formulaRange.isotopes().iterator();
            for (IIsotope isotope : formulaRange.isotopes()) {
                if (formula.getIsotopeCount(isotope) != 0) {
                    if (formula.getIsotopeCount(isotope) >= formulaRange.getIsotopeCountMin(isotope) && formula.getIsotopeCount(isotope) <= formulaRange.getIsotopeCountMax(isotope)) continue;
                    flagCorrect = false;
                    break;
                }
                if (formulaRange.getIsotopeCountMin(isotope) == 0) continue;
                flagCorrect = false;
                break;
            }
            for (IIsotope isotope : formula.isotopes()) {
                if (formulaRange.contains(isotope)) continue;
                flagCorrect = false;
                break;
            }
            if (!flagCorrect) continue;
            newFormulaSet.addMolecularFormula(formula);
        }
        return newFormulaSet;
    }
}

