/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.manipulator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.sgroup.Sgroup;
import org.openscience.cdk.sgroup.SgroupBracket;
import org.openscience.cdk.sgroup.SgroupKey;

public final class SgroupManipulator {
    private SgroupManipulator() {
    }

    private static <T extends IChemObject> T get(Map<? extends IChemObject, ? extends IChemObject> map, T obj) {
        if (map == null) {
            return obj;
        }
        IChemObject val = map.get(obj);
        if (val == null) {
            return obj;
        }
        return (T)val;
    }

    public static List<Sgroup> copy(Collection<Sgroup> sgroups, Map<? extends IChemObject, ? extends IChemObject> replace) {
        if (sgroups == null) {
            return null;
        }
        HashMap<Sgroup, Sgroup> sgroupMap = new HashMap<Sgroup, Sgroup>();
        for (Sgroup sgroup : sgroups) {
            sgroupMap.put(sgroup, new Sgroup());
        }
        for (Map.Entry entry : sgroupMap.entrySet()) {
            Sgroup orgSgroup = (Sgroup)entry.getKey();
            Sgroup cpySgroup = (Sgroup)entry.getValue();
            cpySgroup.setType(orgSgroup.getType());
            for (IAtom atom : orgSgroup.getAtoms()) {
                cpySgroup.addAtom(SgroupManipulator.get(replace, atom));
            }
            for (IBond bond : orgSgroup.getBonds()) {
                cpySgroup.addBond(SgroupManipulator.get(replace, bond));
            }
            for (Sgroup parent : orgSgroup.getParents()) {
                cpySgroup.addParent((Sgroup)sgroupMap.get(parent));
            }
            block9: for (Iterator<Object> iterator : SgroupKey.values()) {
                switch (1.$SwitchMap$org$openscience$cdk$sgroup$SgroupKey[((Enum)((Object)iterator)).ordinal()]) {
                    case 1: {
                        Collection orgVal = (Collection)orgSgroup.getValue((SgroupKey)((Object)iterator));
                        if (orgVal == null) continue block9;
                        ArrayList<IAtom> cpyVal = new ArrayList<IAtom>();
                        for (IAtom atom : orgVal) {
                            cpyVal.add(SgroupManipulator.get(replace, atom));
                        }
                        cpySgroup.putValue((SgroupKey)((Object)iterator), cpyVal);
                        continue block9;
                    }
                    case 2: {
                        Collection orgVals = (Collection)orgSgroup.getValue((SgroupKey)((Object)iterator));
                        if (orgVals == null) continue block9;
                        for (SgroupBracket bracket : orgVals) {
                            cpySgroup.addBracket(new SgroupBracket(bracket));
                        }
                        continue block9;
                    }
                    default: {
                        Object val = orgSgroup.getValue((SgroupKey)((Object)iterator));
                        if (val == null) continue block9;
                        cpySgroup.putValue((SgroupKey)((Object)iterator), val);
                    }
                }
            }
        }
        return new ArrayList<Sgroup>(sgroupMap.values());
    }
}

