/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.graph.cost.trees.lagrangian;

import gnu.trove.list.array.TIntArrayList;
import java.util.BitSet;
import org.chocosolver.solver.constraints.graph.cost.GraphLagrangianRelaxation;
import org.chocosolver.solver.constraints.graph.cost.trees.lagrangian.AbstractTreeFinder;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.util.graphOperations.LCAGraphManager;
import org.chocosolver.util.objects.graphs.DirectedGraph;
import org.chocosolver.util.objects.graphs.UndirectedGraph;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetType;
import org.chocosolver.util.sort.ArraySort;
import org.chocosolver.util.sort.IntComparator;

public class KruskalMSTFinder
extends AbstractTreeFinder {
    protected TIntArrayList ma;
    protected int[] sortedArcs;
    protected int[][] indexOfArc;
    protected BitSet activeArcs;
    protected double[] costs;
    protected int[] p;
    protected int[] rank;
    protected int ccN;
    protected DirectedGraph ccTree;
    protected int[] ccTp;
    protected double[] ccTEdgeCost;
    protected LCAGraphManager lca;
    protected int fromInterest;
    protected int cctRoot;
    protected BitSet useful;
    protected double minTArc;
    protected double maxTArc;
    protected double[][] distMatrix;
    protected ArraySort<?> sorter;
    protected IntComparator comparator;

    public KruskalMSTFinder(int nbNodes, GraphLagrangianRelaxation propagator) {
        super(nbNodes, propagator);
        this.activeArcs = new BitSet(this.n * this.n);
        this.rank = new int[this.n];
        this.costs = new double[this.n * this.n];
        this.sortedArcs = new int[this.n * this.n];
        this.indexOfArc = new int[this.n][this.n];
        this.p = new int[this.n];
        this.ccN = 2 * this.n + 1;
        this.ccTree = new DirectedGraph(this.ccN, SetType.LINKED_LIST, false);
        this.ccTEdgeCost = new double[this.ccN];
        this.ccTp = new int[this.n];
        this.useful = new BitSet(this.n);
        this.lca = new LCAGraphManager(this.ccN);
        this.sorter = new ArraySort(this.n * this.n, false, true);
        this.comparator = (i1, i2) -> Double.compare(this.costs[i1], this.costs[i2]);
    }

    @Override
    public void computeMST(double[][] costs, UndirectedGraph graph) throws ContradictionException {
        this.g = graph;
        this.distMatrix = costs;
        this.ma = this.propHK.getMandatoryArcsList();
        this.sortArcs();
        this.treeCost = 0.0;
        this.cctRoot = this.n - 1;
        int tSize = this.addMandatoryArcs();
        this.connectMST(tSize);
    }

    protected void sortArcs() {
        int i;
        int size = 0;
        for (int i2 = 0; i2 < this.n; ++i2) {
            this.p[i2] = i2;
            this.rank[i2] = 0;
            this.ccTp[i2] = i2;
            this.Tree.getNeighborsOf(i2).clear();
            this.ccTree.removeNode(i2);
            this.ccTree.addNode(i2);
            size += this.g.getNeighborsOf(i2).size();
        }
        assert (size % 2 == 0);
        size /= 2;
        int idx = 0;
        for (i = 0; i < this.n; ++i) {
            ISet nei = this.g.getNeighborsOf(i);
            ISetIterator iSetIterator = nei.iterator();
            while (iSetIterator.hasNext()) {
                int j = (Integer)iSetIterator.next();
                if (i >= j) continue;
                this.sortedArcs[idx] = i * this.n + j;
                this.costs[i * this.n + j] = this.distMatrix[i][j];
                ++idx;
            }
        }
        for (i = this.n; i < this.ccN; ++i) {
            this.ccTree.removeNode(i);
        }
        this.sorter.sort(this.sortedArcs, size, this.comparator);
        this.activeArcs.clear();
        this.activeArcs.set(0, size);
        idx = 0;
        while (idx < size) {
            int v = this.sortedArcs[idx];
            this.indexOfArc[v / this.n][v % this.n] = idx++;
        }
    }

    @Override
    public void performPruning(double UB) throws ContradictionException {
        double delta = UB - this.treeCost;
        assert (delta >= 0.0);
        this.fromInterest = 0;
        if (this.selectAndCompress(delta)) {
            this.lca.preprocess(this.cctRoot, this.ccTree);
            this.pruning(this.fromInterest, delta);
        }
    }

    protected boolean selectRelevantArcs(double delta) throws ContradictionException {
        int idx = this.activeArcs.nextSetBit(0);
        while (idx >= 0 && this.costs[this.sortedArcs[idx]] - this.minTArc <= delta) {
            idx = this.activeArcs.nextSetBit(idx + 1);
        }
        if (idx == -1) {
            return false;
        }
        this.fromInterest = idx;
        while (idx >= 0 && this.costs[this.sortedArcs[idx]] - this.maxTArc <= delta) {
            idx = this.activeArcs.nextSetBit(idx + 1);
        }
        while (idx >= 0) {
            if (!this.Tree.containsEdge(this.sortedArcs[idx] / this.n, this.sortedArcs[idx] % this.n)) {
                this.propHK.remove(this.sortedArcs[idx] / this.n, this.sortedArcs[idx] % this.n);
                this.activeArcs.clear(idx);
            }
            idx = this.activeArcs.nextSetBit(idx + 1);
        }
        this.ccTree.addEdge(this.cctRoot, 0);
        return true;
    }

    protected boolean selectAndCompress(double delta) throws ContradictionException {
        int idx = this.activeArcs.nextSetBit(0);
        while (idx >= 0 && this.costs[this.sortedArcs[idx]] - this.minTArc <= delta) {
            idx = this.activeArcs.nextSetBit(idx + 1);
        }
        if (idx == -1) {
            return false;
        }
        this.fromInterest = idx;
        this.useful.clear();
        while (idx >= 0 && this.costs[this.sortedArcs[idx]] - this.maxTArc <= delta) {
            this.useful.set(this.sortedArcs[idx] / this.n);
            this.useful.set(this.sortedArcs[idx] % this.n);
            idx = this.activeArcs.nextSetBit(idx + 1);
        }
        while (idx >= 0) {
            if (!this.Tree.containsEdge(this.sortedArcs[idx] / this.n, this.sortedArcs[idx] % this.n)) {
                this.propHK.remove(this.sortedArcs[idx] / this.n, this.sortedArcs[idx] % this.n);
                this.activeArcs.clear(idx);
            }
            idx = this.activeArcs.nextSetBit(idx + 1);
        }
        if (this.useful.cardinality() == 0) {
            return false;
        }
        int i22 = this.useful.nextClearBit(0);
        while (i22 < this.n) {
            this.ccTree.removeNode(i22);
            i22 = this.useful.nextClearBit(i22 + 1);
        }
        ISetIterator i22 = this.ccTree.getNodes().iterator();
        while (i22.hasNext()) {
            int i = (Integer)i22.next();
            if (this.ccTree.getSuccessorsOf(i).isEmpty()) {
                if (i < this.n) continue;
                this.ccTree.removeNode(i);
                continue;
            }
            if (this.ccTree.getSuccessorsOf(i).size() != 1) continue;
            int s = this.ccTree.getSuccessorsOf(i).iterator().next();
            this.ccTree.removeNode(i);
            if (this.ccTree.getPredecessorsOf(i).isEmpty()) continue;
            int p = this.ccTree.getPredecessorsOf(i).iterator().next();
            this.ccTree.addEdge(p, s);
        }
        ++this.cctRoot;
        int newNode = this.cctRoot;
        this.ccTree.addNode(newNode);
        this.ccTEdgeCost[newNode] = this.propHK.getMinArcVal();
        ISetIterator iSetIterator = this.ccTree.getNodes().iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            if (i == this.cctRoot || !this.ccTree.getPredecessorsOf(i).isEmpty()) continue;
            this.ccTree.addEdge(this.cctRoot, i);
        }
        return true;
    }

    protected void pruning(int fi, double delta) throws ContradictionException {
        int arc = this.activeArcs.nextSetBit(fi);
        while (arc >= 0) {
            int i = this.sortedArcs[arc] / this.n;
            int j = this.sortedArcs[arc] % this.n;
            if (!this.Tree.containsEdge(i, j)) {
                if (this.propHK.isMandatory(i, j)) {
                    throw new UnsupportedOperationException();
                }
                double repCost = this.ccTEdgeCost[this.lca.getLCA(i, j)];
                if (this.costs[i * this.n + j] - repCost > delta) {
                    this.activeArcs.clear(arc);
                    this.propHK.remove(i, j);
                }
            }
            arc = this.activeArcs.nextSetBit(arc + 1);
        }
    }

    protected int addMandatoryArcs() throws ContradictionException {
        int tSize = 0;
        double val = this.propHK.getMinArcVal();
        for (int i = this.ma.size() - 1; i >= 0; --i) {
            int rTo;
            int arc = this.ma.get(i);
            int from = arc / this.n;
            int to = arc % this.n;
            int rFrom = this.findUF(from);
            if (rFrom != (rTo = this.findUF(to))) {
                this.linkUF(rFrom, rTo);
                this.Tree.addEdge(from, to);
                this.updateCCTree(rFrom, rTo, val);
                this.treeCost += this.costs[arc];
                ++tSize;
                continue;
            }
            this.propHK.contradiction();
        }
        return tSize;
    }

    protected void connectMST(int treeSize) throws ContradictionException {
        int idx = this.activeArcs.nextSetBit(0);
        this.minTArc = -this.propHK.getMinArcVal();
        this.maxTArc = this.propHK.getMinArcVal();
        int tSize = treeSize;
        while (tSize < this.n - 1) {
            int rTo;
            if (idx < 0) {
                this.propHK.contradiction();
            }
            int from = this.sortedArcs[idx] / this.n;
            int to = this.sortedArcs[idx] % this.n;
            int rFrom = this.findUF(from);
            if (rFrom != (rTo = this.findUF(to))) {
                this.linkUF(rFrom, rTo);
                this.Tree.addEdge(from, to);
                double cost = this.costs[this.sortedArcs[idx]];
                this.updateCCTree(rFrom, rTo, cost);
                if (cost > this.maxTArc) {
                    this.maxTArc = cost;
                }
                if (cost < this.minTArc) {
                    this.minTArc = cost;
                }
                this.treeCost += cost;
                ++tSize;
            }
            idx = this.activeArcs.nextSetBit(idx + 1);
        }
    }

    protected void updateCCTree(int rfrom, int rto, double cost) {
        ++this.cctRoot;
        int newNode = this.cctRoot;
        this.ccTree.addNode(newNode);
        this.ccTree.addEdge(newNode, this.ccTp[rfrom]);
        this.ccTree.addEdge(newNode, this.ccTp[rto]);
        this.ccTp[rfrom] = newNode;
        this.ccTp[rto] = newNode;
        this.ccTEdgeCost[newNode] = cost;
    }

    protected void linkUF(int x, int y) {
        if (this.rank[x] > this.rank[y]) {
            this.p[y] = this.p[x];
        } else {
            this.p[x] = this.p[y];
        }
        if (this.rank[x] == this.rank[y]) {
            int n = y;
            this.rank[n] = this.rank[n] + 1;
        }
    }

    protected int findUF(int i) {
        if (this.p[i] != i) {
            this.p[i] = this.findUF(this.p[i]);
        }
        return this.p[i];
    }
}

