/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.coalescent;

import dr.evolution.coalescent.IntervalType;
import dr.evolution.coalescent.MutableIntervalList;
import dr.evolution.util.Units;
import dr.math.MathUtils;
import java.util.Arrays;

public class FastIntervals
implements MutableIntervalList {
    private Units.Type units = Units.Type.GENERATIONS;
    private double startTime = Double.POSITIVE_INFINITY;
    private double finishTime = Double.NEGATIVE_INFINITY;
    private int cumulativeSampleCount;
    private int cumulativeCoalescentCount;
    private boolean intervalsKnown;
    private final double[] sampleTimes;
    private final double[] coalescentTimes;
    private final double[] eventTimes;
    private final int eventCount;
    private final int sampleCount;
    private final int coalescentCount;
    private final int intervalCount;
    private final double[] intervals;
    private final int[] lineageCounts;
    private final IntervalType[] intervalTypes;

    public FastIntervals(int n, int n2) {
        this.sampleCount = n;
        this.coalescentCount = n2;
        this.eventCount = n + n2;
        this.intervalCount = this.eventCount - 1;
        this.sampleTimes = new double[n];
        this.coalescentTimes = new double[n2];
        this.eventTimes = new double[this.eventCount];
        this.intervals = new double[this.intervalCount];
        this.intervalTypes = new IntervalType[this.intervalCount];
        this.lineageCounts = new int[this.intervalCount];
        this.cumulativeSampleCount = 0;
        this.cumulativeCoalescentCount = 0;
        this.intervalsKnown = false;
    }

    @Override
    public void copyIntervals(MutableIntervalList mutableIntervalList) {
        FastIntervals fastIntervals = (FastIntervals)mutableIntervalList;
        this.intervalsKnown = fastIntervals.intervalsKnown;
        assert (this.eventCount == fastIntervals.eventCount);
        assert (this.sampleCount == fastIntervals.sampleCount);
        assert (this.coalescentCount == fastIntervals.coalescentCount);
        assert (this.intervalCount == fastIntervals.intervalCount);
        this.startTime = fastIntervals.startTime;
        if (this.intervalsKnown) {
            System.arraycopy(fastIntervals.intervals, 0, this.intervals, 0, this.intervals.length);
            System.arraycopy(fastIntervals.intervalTypes, 0, this.intervalTypes, 0, this.intervals.length);
            System.arraycopy(fastIntervals.lineageCounts, 0, this.lineageCounts, 0, this.intervals.length);
        }
    }

    @Override
    public void resetEvents() {
        this.startTime = Double.POSITIVE_INFINITY;
        this.finishTime = Double.NEGATIVE_INFINITY;
        this.intervalsKnown = false;
        this.cumulativeSampleCount = 0;
        this.cumulativeCoalescentCount = 0;
    }

    @Override
    public void addSampleEvent(double d) {
        if (d < this.startTime) {
            this.startTime = d;
        }
        this.sampleTimes[this.cumulativeSampleCount] = d;
        ++this.cumulativeSampleCount;
        this.intervalsKnown = false;
    }

    @Override
    public void addSampleEvent(double d, int n) {
        this.addSampleEvent(d);
    }

    @Override
    public void addCoalescentEvent(double d) {
        if (d > this.finishTime) {
            this.finishTime = d;
        }
        this.coalescentTimes[this.cumulativeCoalescentCount] = d;
        ++this.cumulativeCoalescentCount;
        this.intervalsKnown = false;
    }

    @Override
    public void addCoalescentEvent(double d, int n) {
        this.addCoalescentEvent(d);
    }

    @Override
    public void addMigrationEvent(double d, int n) {
        throw new UnsupportedOperationException("not supported in FastIntervals");
    }

    @Override
    public void addNothingEvent(double d) {
        throw new UnsupportedOperationException("not supported in FastIntervals");
    }

    @Override
    public int getNodeForEvent(int n) {
        throw new UnsupportedOperationException("not supported in FastIntervals");
    }

    @Override
    public int getSampleCount() {
        return this.sampleCount;
    }

    @Override
    public int getIntervalCount() {
        if (!this.intervalsKnown) {
            this.calculateIntervals();
        }
        return this.intervalCount;
    }

    @Override
    public double getInterval(int n) {
        if (!this.intervalsKnown) {
            this.calculateIntervals();
        }
        return this.intervals[n];
    }

    @Override
    public double getIntervalTime(int n) {
        if (!this.intervalsKnown) {
            this.calculateIntervals();
        }
        return this.eventTimes[n];
    }

    @Override
    public int getLineageCount(int n) {
        if (!this.intervalsKnown) {
            this.calculateIntervals();
        }
        return this.lineageCounts[n];
    }

    @Override
    public int getCoalescentEvents(int n) {
        if (!this.intervalsKnown) {
            this.calculateIntervals();
        }
        if (n < this.intervalCount - 1) {
            return this.lineageCounts[n] - this.lineageCounts[n + 1];
        }
        return this.lineageCounts[n] - 1;
    }

    @Override
    public double getStartTime() {
        if (!this.intervalsKnown) {
            this.calculateIntervals();
        }
        return this.startTime;
    }

    @Override
    public IntervalType getIntervalType(int n) {
        if (!this.intervalsKnown) {
            this.calculateIntervals();
        }
        return this.intervalTypes[n];
    }

    @Override
    public double getTotalDuration() {
        if (!this.intervalsKnown) {
            this.calculateIntervals();
        }
        return this.finishTime - this.startTime;
    }

    @Override
    public boolean isBinaryCoalescent() {
        return true;
    }

    @Override
    public boolean isCoalescentOnly() {
        return true;
    }

    @Override
    public void calculateIntervals() {
        if (this.eventCount < 2) {
            throw new IllegalArgumentException("Too few events to construct intervals");
        }
        Arrays.sort(this.sampleTimes);
        Arrays.sort(this.coalescentTimes);
        double d = this.sampleTimes[0];
        int n = 1;
        int n2 = 0;
        int n3 = 0;
        int n4 = 1;
        while (n < this.sampleCount || n2 < this.coalescentCount) {
            if (n < this.sampleCount && this.sampleTimes[n] <= this.coalescentTimes[n2]) {
                this.intervals[n3] = this.sampleTimes[n] - d;
                this.eventTimes[n3] = this.sampleTimes[n];
                this.intervalTypes[n3] = IntervalType.SAMPLE;
                this.lineageCounts[n3] = n4++;
                d = this.sampleTimes[n];
                ++n;
            } else {
                this.intervals[n3] = this.coalescentTimes[n2] - d;
                this.eventTimes[n3] = this.coalescentTimes[n2];
                this.intervalTypes[n3] = IntervalType.COALESCENT;
                this.lineageCounts[n3] = n4--;
                d = this.coalescentTimes[n2];
                ++n2;
            }
            ++n3;
        }
        this.intervalsKnown = true;
    }

    @Override
    public final Units.Type getUnits() {
        return this.units;
    }

    @Override
    public final void setUnits(Units.Type type) {
        this.units = type;
    }

    public static void main(String[] stringArray) {
        int n;
        int n2 = 1600;
        int n3 = 1000000;
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        double[] dArray3 = new double[n2];
        Test[] testArray = new Test[n2];
        Object[] objectArray = new Test[n2];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = MathUtils.nextDouble();
            dArray2[i] = MathUtils.nextDouble();
            testArray[i] = new Test(MathUtils.nextDouble());
        }
        Arrays.sort(dArray2);
        long l = System.currentTimeMillis();
        for (n = 0; n < n3; ++n) {
            System.arraycopy(dArray, 0, dArray3, 0, n2);
        }
        System.out.println("Array copy doubles, " + n3 + " reps, time = " + (System.currentTimeMillis() - l));
        l = System.currentTimeMillis();
        for (n = 0; n < n3; ++n) {
            System.arraycopy(testArray, 0, objectArray, 0, n2);
        }
        System.out.println("Array copy objects, " + n3 + " reps, time = " + (System.currentTimeMillis() - l));
        l = System.currentTimeMillis();
        for (n = 0; n < n3; ++n) {
            System.arraycopy(dArray, 0, dArray3, 0, n2);
            Arrays.sort(dArray3);
        }
        System.out.println("Unsorted doubles, " + n3 + " reps, time = " + (System.currentTimeMillis() - l));
        l = System.currentTimeMillis();
        for (n = 0; n < n3; ++n) {
            System.arraycopy(dArray, 0, dArray3, 0, n2);
            Arrays.parallelSort(dArray3);
        }
        System.out.println("Unsorted doubles (parallel sort), " + n3 + " reps, time = " + (System.currentTimeMillis() - l));
        l = System.currentTimeMillis();
        for (n = 0; n < n3; ++n) {
            System.arraycopy(dArray2, 0, dArray3, 0, n2);
            Arrays.sort(dArray3);
        }
        System.out.println("Pre-sorted doubles, " + n3 + " reps, time = " + (System.currentTimeMillis() - l));
        l = System.currentTimeMillis();
        for (n = 0; n < n3; ++n) {
            System.arraycopy(dArray2, 0, dArray3, 0, n2);
            for (int i = 0; i < 3; ++i) {
                dArray3[MathUtils.nextInt((int)n2)] = MathUtils.nextDouble();
            }
            Arrays.sort(dArray3);
        }
        System.out.println("Mostly sorted doubles, " + n3 + " reps, time = " + (System.currentTimeMillis() - l));
        l = System.currentTimeMillis();
        for (n = 0; n < n3; ++n) {
            System.arraycopy(testArray, 0, objectArray, 0, n2);
            Arrays.sort(objectArray);
        }
        System.out.println("Unsorted objects, " + n3 + " reps, time = " + (System.currentTimeMillis() - l));
        l = System.currentTimeMillis();
        for (n = 0; n < n3; ++n) {
            System.arraycopy(testArray, 0, objectArray, 0, n2);
            Arrays.parallelSort((Comparable[])objectArray);
        }
        System.out.println("Unsorted objects (parallel sort), " + n3 + " reps, time = " + (System.currentTimeMillis() - l));
    }

    static class Test
    implements Comparable<Test> {
        double value;

        public Test(double d) {
            this.value = d;
        }

        @Override
        public int compareTo(Test test) {
            return Double.compare(this.value, test.value);
        }
    }
}

