/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent;

import dr.evomodel.bigfasttree.BigFastTreeIntervals;
import dr.evomodel.coalescent.SingleTreeTimeline;
import dr.inference.model.Parameter;
import java.util.Arrays;

public class SingleTreeGriddedNodesTimeline
extends SingleTreeTimeline {
    private final int nNodes = this.getnNodes();
    private final double[] timeLine;
    private final boolean[] flagCoalescentEvent;
    private final Parameter gridPoints;
    private int[] gridIndices;
    private double[] mergedTimeLine;
    private int[] mergedNumLineages;
    private int[] numCoalEvents;

    public SingleTreeGriddedNodesTimeline(BigFastTreeIntervals bigFastTreeIntervals, Parameter parameter) {
        super(bigFastTreeIntervals);
        this.gridPoints = parameter;
        this.timeLine = new double[this.nNodes];
        this.flagCoalescentEvent = new boolean[this.nNodes];
        this.makeNodesLine();
        if (parameter != null) {
            this.mergedTimeLine = new double[this.nNodes + parameter.getDimension()];
            this.gridIndices = new int[parameter.getDimension()];
            this.numCoalEvents = new int[parameter.getDimension() + 1];
            this.mergedNumLineages = new int[this.nNodes + parameter.getDimension() + 1];
            this.integrateGridPoints(parameter.getParameterValues());
        }
    }

    protected void makeNodesLine() {
        this.timeLine[0] = this.treeIntervals.getStartTime();
        this.flagCoalescentEvent[0] = false;
        for (int i = 1; i < this.nNodes; ++i) {
            this.timeLine[i] = this.treeIntervals.getIntervalTime(i);
            this.flagCoalescentEvent[i] = String.valueOf((Object)this.treeIntervals.getIntervalType(i - 1)).equals("coalescent");
        }
    }

    private void integrateGridPoints(double[] dArray) {
        int n = dArray.length;
        Arrays.fill(this.mergedNumLineages, 0);
        Arrays.fill(this.numCoalEvents, 0);
        int n2 = 0;
        int n3 = 0;
        while (n2 < this.nNodes && n3 < n) {
            if (this.timeLine[n2] <= dArray[n3]) {
                this.mergedTimeLine[n2 + n3] = this.timeLine[n2];
                this.computeNumLineages(n2 + n3, this.flagCoalescentEvent[n2]);
                if (this.flagCoalescentEvent[n2]) {
                    int n4 = n3;
                    this.numCoalEvents[n4] = this.numCoalEvents[n4] + 1;
                }
                ++n2;
                continue;
            }
            this.mergedTimeLine[n2 + n3] = dArray[n3];
            this.gridIndices[n3] = n2 + n3;
            this.mergedNumLineages[n2 + n3] = this.mergedNumLineages[n2 + n3 - 1];
            ++n3;
        }
        while (n2 < this.nNodes) {
            this.mergedTimeLine[n2 + n3] = this.timeLine[n2];
            this.computeNumLineages(n2 + n3, this.flagCoalescentEvent[n2]);
            if (this.flagCoalescentEvent[n2]) {
                int n5 = n3;
                this.numCoalEvents[n5] = this.numCoalEvents[n5] + 1;
            }
            ++n2;
        }
        while (n3 < n) {
            this.mergedTimeLine[n2 + n3] = dArray[n3];
            this.gridIndices[n3] = n2 + n3;
            this.mergedNumLineages[n2 + n3] = this.mergedNumLineages[n2 + n3 - 1];
            ++n3;
        }
    }

    private void computeNumLineages(int n, boolean bl) {
        this.mergedNumLineages[n] = bl ? this.mergedNumLineages[n - 1] - 1 : (n == 0 ? 1 : this.mergedNumLineages[n - 1] + 1);
    }

    public double[] getMergedTimeLine() {
        return this.mergedTimeLine;
    }

    public int[] getMergedNumLineages() {
        return this.mergedNumLineages;
    }

    public int[] getNumCoalEvents() {
        return this.numCoalEvents;
    }

    public int[] getGridIndices() {
        return this.gridIndices;
    }
}

