/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tree;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeUtils;
import dr.evolution.util.Taxon;
import dr.evolution.util.TaxonList;
import dr.evomodel.tree.TreeStatistic;
import dr.inference.model.BooleanStatistic;
import java.util.Set;

public class AncestorOnStemStatistic
extends TreeStatistic
implements BooleanStatistic {
    private Tree tree;
    private final Taxon ancestor;
    private final Set<String> leafSet;

    public AncestorOnStemStatistic(String string, Tree tree, Taxon taxon, TaxonList taxonList) throws TreeUtils.MissingTaxonException {
        super(string);
        this.tree = tree;
        this.ancestor = taxon;
        this.leafSet = TreeUtils.getLeavesForTaxa(tree, taxonList);
    }

    @Override
    public void setTree(Tree tree) {
        this.tree = tree;
    }

    @Override
    public Tree getTree() {
        return this.tree;
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public double getStatisticValue(int n) {
        return this.getBoolean(n) ? 1.0 : 0.0;
    }

    @Override
    public boolean getBoolean(int n) {
        NodeRef nodeRef = TreeUtils.getCommonAncestorNode(this.tree, this.leafSet);
        if (nodeRef == this.tree.getRoot()) {
            return false;
        }
        NodeRef nodeRef2 = this.tree.getParent(nodeRef);
        NodeRef nodeRef3 = this.getOtherChild(nodeRef2, nodeRef);
        Taxon taxon = this.tree.getNodeTaxon(nodeRef3);
        if (taxon == null || taxon != this.ancestor) {
            return false;
        }
        double d = this.tree.getNodeHeight(nodeRef2);
        double d2 = this.tree.isRoot(nodeRef2) ? Double.POSITIVE_INFINITY : this.tree.getNodeHeight(this.tree.getParent(nodeRef2));
        return d2 > d;
    }

    private NodeRef getOtherChild(NodeRef nodeRef, NodeRef nodeRef2) {
        NodeRef nodeRef3 = this.tree.getChild(nodeRef, 0);
        if (nodeRef3 == nodeRef2) {
            nodeRef3 = this.tree.getChild(nodeRef, 1);
        }
        return nodeRef3;
    }
}

