/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tree.randomlocalmodel;

import dr.stats.DiscreteStatistics;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class RLTVAnalyzer {
    static TreeMap<Integer, List<Double>> nodeRates = new TreeMap();
    static Map<String, Integer> comboCounts = new HashMap<String, Integer>();
    static Map<String, Integer> pairCounts = new HashMap<String, Integer>();
    static NumberFormat format = NumberFormat.getNumberInstance(Locale.ENGLISH);
    static Comparator<RateCombo> rateComboComparator = new Comparator<RateCombo>(){

        @Override
        public int compare(RateCombo rateCombo, RateCombo rateCombo2) {
            return rateCombo2.count - rateCombo.count;
        }
    };

    public static void main(String[] stringArray) throws IOException {
        Object object;
        Object object2;
        int n = 0;
        double d = Double.parseDouble(stringArray[1]);
        format.setMaximumFractionDigits(5);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(stringArray[0]));
        String string = bufferedReader.readLine();
        while (string.toLowerCase().startsWith("state")) {
            string = bufferedReader.readLine();
        }
        while (string != null) {
            object2 = new StringTokenizer(string);
            ((StringTokenizer)object2).nextToken();
            object = new ArrayList();
            while (((StringTokenizer)object2).hasMoreTokens()) {
                int n2 = Integer.parseInt(((StringTokenizer)object2).nextToken());
                double d3 = Double.parseDouble(((StringTokenizer)object2).nextToken());
                object.add(n2);
                RLTVAnalyzer.putRate(n2, d3);
            }
            RLTVAnalyzer.putCombo((List<Integer>)object);
            ++n;
            string = bufferedReader.readLine();
        }
        object2 = new ArrayList();
        for (Map.Entry entry : comboCounts.entrySet()) {
            int entry2 = (Integer)entry.getValue();
            if (entry2 <= 1) continue;
            object2.add(new RateCombo((String)entry.getKey(), entry2));
        }
        Collections.sort(object2, rateComboComparator);
        System.out.println("combo\tPr");
        object = object2.iterator();
        while (object.hasNext()) {
            RateCombo rateCombo = (RateCombo)object.next();
            double rateCombo2 = (double)rateCombo.count / (double)n;
            String[] d6 = rateCombo.combo.split("-");
            System.out.println(rateCombo.combo + "\t" + format.format(rateCombo2));
        }
        object = new ArrayList();
        for (Map.Entry<String, Integer> iterator : pairCounts.entrySet()) {
            int n5 = iterator.getValue();
            if (n5 <= 1) continue;
            object.add(new RateCombo(iterator.getKey(), n5));
        }
        Collections.sort(object, rateComboComparator);
        System.out.println();
        System.out.println("pair\tPr");
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            RateCombo rateCombo = (RateCombo)iterator.next();
            double rateCombo3 = (double)rateCombo.count / (double)n;
            System.out.println(rateCombo.combo + "\t" + format.format(rateCombo3));
        }
        ArrayList<RateCombo> arrayList = new ArrayList<RateCombo>();
        for (int n2 : nodeRates.keySet()) {
            int n3 = nodeRates.get(n2).size();
            if (n3 <= 1) continue;
            double d2 = RLTVAnalyzer.getMeanRate(n2);
            double[] dArray = RLTVAnalyzer.getRateCPD(n2);
            String string2 = format.format(d2) + "\t" + format.format(dArray[0]) + "\t" + format.format(dArray[1]);
            arrayList.add(new RateCombo(n2 + "\t" + string2, n3));
        }
        Collections.sort(arrayList, rateComboComparator);
        System.out.println();
        System.out.println("node change\trate\t95% lower\t95% upper\tPr\tBF");
        for (RateCombo rateCombo : arrayList) {
            double d3 = (double)rateCombo.count / (double)n;
            double d4 = RLTVAnalyzer.bayesFactor(d3, d);
            System.out.println(rateCombo.combo + "\t" + format.format(d3) + "\t" + format.format(d4));
        }
    }

    private static double bayesFactor(double d, double d2) {
        double d3 = d / d2;
        double d4 = (1.0 - d) / (1.0 - d2);
        return d3 / d4;
    }

    private static void putCombo(List<Integer> list) {
        int n;
        if (list.size() == 0) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            for (n = i + 1; n < list.size(); ++n) {
                RLTVAnalyzer.putPair(list.get(i), list.get(n));
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(list.get(0));
        for (n = 1; n < list.size(); ++n) {
            stringBuilder.append("-");
            stringBuilder.append(list.get(n));
        }
        String string = stringBuilder.toString();
        Integer n2 = comboCounts.get(string);
        if (n2 == null) {
            comboCounts.put(string, 1);
        } else {
            comboCounts.put(string, n2 + 1);
        }
    }

    private static void putPair(int n, int n2) {
        String string = "{" + n + "," + n2 + "}";
        Integer n3 = pairCounts.get(string);
        if (n3 == null) {
            pairCounts.put(string, 1);
        } else {
            pairCounts.put(string, n3 + 1);
        }
    }

    private static void putRate(int n, double d) {
        List<Double> list = nodeRates.get(n);
        if (list == null) {
            list = new ArrayList<Double>();
            nodeRates.put(n, list);
        }
        list.add(d);
    }

    private static double getStdevRate(int n) {
        List<Double> list = nodeRates.get(n);
        double[] dArray = new double[list.size()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = list.get(i);
        }
        return DiscreteStatistics.stdev(dArray);
    }

    private static double[] getRateCPD(int n) {
        List<Double> list = nodeRates.get(n);
        double[] dArray = new double[list.size()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = list.get(i);
        }
        return new double[]{DiscreteStatistics.quantile(0.025, dArray), DiscreteStatistics.quantile(0.975, dArray)};
    }

    private static double getMeanRate(int n) {
        List<Double> list = nodeRates.get(n);
        double d = 0.0;
        for (double d2 : list) {
            d += d2;
        }
        return d /= (double)list.size();
    }

    static class RateCombo {
        final String combo;
        final int count;

        public RateCombo(String string, int n) {
            this.combo = string;
            this.count = n;
        }

        public boolean equals(Object object) {
            assert (object instanceof RateCombo);
            RateCombo rateCombo = (RateCombo)object;
            return this.combo.equals(rateCombo.combo) && this.count == rateCombo.count;
        }
    }
}

