/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.hawkes;

import dr.inference.hawkes.HawkesCore;
import dr.inference.hawkes.NativeHPHSingleton;
import dr.math.matrixAlgebra.Vector;

public class MassivelyParallelHPHImpl
implements HawkesCore {
    private NativeHPHSingleton singleton = NativeHPHSingleton.loadLibrary();
    private int instance = -1;
    private final HawkesCore.CoreInformation information = new HawkesCore.CoreInformation();
    private int observationCount;
    private double tauXprec;
    private double storedTauXprec;
    private double tauTprec;
    private double storedTauTprec;
    private double sigmaXprec;
    private double storedSigmaXprec;
    private double omega;
    private double storedOmega;
    private double theta;
    private double storedTheta;
    private double mu0;
    private double storedMu0;
    private static final boolean CHECK_GRADIENT = false;
    private static final boolean CHECK_GRADIENT_KILL = true;

    MassivelyParallelHPHImpl() {
        String string;
        String string2 = System.getProperty("hph.resource");
        if (string2 != null) {
            try {
                int n = Integer.parseInt(string2);
                if (n > 0) {
                    this.information.deviceNumber = n - 1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new RuntimeException("Unable to parse 'hph.resource' environmental property");
            }
        }
        if ((string = System.getProperty("hph.threads")) != null) {
            try {
                this.information.numThreads = Integer.parseInt(string.trim());
            }
            catch (NumberFormatException numberFormatException) {
                throw new RuntimeException("Unable to parse 'hph.threads' environmental property");
            }
        }
    }

    @Override
    public void initialize(int n, int n2, long l) {
        this.information.flags = l;
        this.instance = this.singleton.initialize(n, n2, this.information);
        this.observationCount = n2 * (n2 - 1) / 2;
    }

    @Override
    public void setTimesData(double[] dArray) {
        this.singleton.setTimesData(this.instance, dArray);
    }

    @Override
    public void setRandomRates(double[] dArray) {
        this.singleton.setRandomRates(this.instance, dArray);
    }

    @Override
    public void setParameters(double[] dArray) {
        this.sigmaXprec = dArray[0];
        this.tauXprec = dArray[1];
        this.tauTprec = dArray[2];
        this.omega = dArray[3];
        this.theta = dArray[4];
        this.mu0 = dArray[5];
        this.singleton.setParameters(this.instance, dArray);
    }

    @Override
    public void updateLocation(int n, double[] dArray) {
        this.singleton.updateLocations(this.instance, n, dArray);
    }

    @Override
    public double calculateLogLikelihood() {
        double d = this.singleton.getSumOfIncrements(this.instance);
        return d;
    }

    @Override
    public void storeState() {
        this.singleton.storeState(this.instance);
        this.storedSigmaXprec = this.sigmaXprec;
        this.storedTauXprec = this.tauXprec;
        this.storedTauTprec = this.tauTprec;
        this.storedOmega = this.omega;
        this.storedTheta = this.theta;
        this.storedMu0 = this.mu0;
    }

    @Override
    public void restoreState() {
        this.sigmaXprec = this.storedSigmaXprec;
        this.tauXprec = this.storedTauXprec;
        this.tauTprec = this.storedTauTprec;
        this.omega = this.storedOmega;
        this.theta = this.storedTheta;
        this.mu0 = this.storedMu0;
    }

    @Override
    public void acceptState() {
        this.singleton.acceptState(this.instance);
    }

    @Override
    public void getLocationGradient(double[] dArray) {
        this.singleton.getLocationGradient(this.instance, dArray);
    }

    @Override
    public void getRandomRatesGradient(double[] dArray) {
        this.singleton.getRandomRatesGradient(this.instance, dArray);
    }

    private void checkGradient(double[] dArray) {
        for (double d : dArray) {
            if (!Double.isNaN(d) && !Double.isInfinite(d)) continue;
            System.err.println("Poor gradient value: " + d);
            System.err.println(new Vector(dArray));
            System.exit(-1);
        }
    }

    @Override
    public void makeDirty() {
    }

    @Override
    public int getInternalDimension() {
        return this.singleton.getInternalDimension(this.instance);
    }
}

