/*
 * Decompiled with CFR 0.152.
 */
package dr.util;

import dr.util.LKJCholeskyTransformConstrained;

public class LKJCholeskyTransformConstrainedWithDiag
extends LKJCholeskyTransformConstrained {
    private int dimCPC;
    private final int totalDimension;

    LKJCholeskyTransformConstrainedWithDiag(int n) {
        super(n);
        this.dimCPC = n * (n - 1) / 2;
        this.totalDimension = n * (n + 1) / 2;
    }

    @Override
    protected double[] transform(double[] dArray) {
        double[] dArray2 = this.subsetCholeskyOrCPCs(dArray);
        double[] dArray3 = this.subsetDiagonals(dArray);
        double[] dArray4 = super.transform(dArray2, 0, this.dimCPC);
        return this.pasteTogether(dArray4, dArray3);
    }

    @Override
    protected double[] inverse(double[] dArray) {
        assert (dArray.length == this.totalDimension) : "The transform function can only be applied to CPCs appended with diagonals";
        for (int i = 0; i < this.dimCPC; ++i) {
            assert (dArray[i] <= 1.0 && dArray[i] >= -1.0) : "CPCs must be between -1.0 and 1.0";
        }
        double[] dArray2 = this.subsetCholeskyOrCPCs(dArray);
        double[] dArray3 = this.subsetDiagonals(dArray);
        double[] dArray4 = super.inverse(dArray2, 0, dArray2.length);
        return this.pasteTogether(dArray4, dArray3);
    }

    @Override
    public double[][] computeJacobianMatrixInverse(double[] dArray) {
        double[] dArray2 = this.subsetCholeskyOrCPCs(dArray);
        double[][] dArray3 = super.computeJacobianMatrixInverse(dArray2);
        return this.appendIdentityMatrix(dArray3);
    }

    @Override
    public double[] getGradientLogJacobianInverse(double[] dArray) {
        double[] dArray2 = this.subsetCholeskyOrCPCs(dArray);
        double[] dArray3 = super.getGradientLogJacobianInverse(dArray2);
        return this.pasteTogether(dArray3, new double[this.dimVector]);
    }

    private double[] subsetCholeskyOrCPCs(double[] dArray) {
        assert (dArray.length == this.totalDimension);
        double[] dArray2 = new double[this.dimCPC];
        System.arraycopy(dArray, this.dimVector, dArray2, 0, this.dimCPC);
        return dArray2;
    }

    private double[] subsetDiagonals(double[] dArray) {
        assert (dArray.length == this.totalDimension);
        double[] dArray2 = new double[this.dimVector];
        System.arraycopy(dArray, 0, dArray2, 0, this.dimVector);
        return dArray2;
    }

    private double[][] appendIdentityMatrix(double[][] dArray) {
        assert (dArray.length == this.dimCPC);
        int n = this.dimCPC + this.dimVector;
        double[][] dArray2 = new double[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                if (i >= this.dimCPC || j >= this.dimCPC) {
                    if (i != j) continue;
                    dArray2[i][j] = 1.0;
                    continue;
                }
                dArray2[i][j] = dArray[i][j];
            }
        }
        return dArray2;
    }

    private double[] pasteTogether(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[this.dimCPC + this.dimVector];
        System.arraycopy(dArray2, 0, dArray3, 0, this.dimVector);
        System.arraycopy(dArray, 0, dArray3, this.dimVector, this.dimCPC);
        return dArray3;
    }

    @Override
    public double[] updateDiagonalHessianLogDensity(double[] dArray, double[] dArray2, double[] dArray3, int n, int n2) {
        throw new RuntimeException("Not yet implemented");
    }
}

