/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.widgets.param;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.rosuda.JGR.layout.AnchorConstraint;
import org.rosuda.JGR.layout.AnchorLayout;
import org.rosuda.deducer.widgets.param.Param;
import org.rosuda.deducer.widgets.param.ParamNumeric;
import org.rosuda.deducer.widgets.param.ParamWidget;

public class ParamTextFieldWidget
extends ParamWidget
implements FocusListener {
    private JTextField textField;

    public ParamTextFieldWidget() {
    }

    public ParamTextFieldWidget(Param param) {
        this.setModel(param);
    }

    @Override
    public void setModel(Param param) {
        this.model = param;
        if (param.getViewType().equals("org.rosuda.deducer.widgets.param.ParamTextFieldWidget")) {
            this.initAsShortTextField();
            this.label.setText(param.getTitle());
            if (param.getValue() != null) {
                this.textField.setText(param.getValue().toString());
            }
            if (param instanceof ParamNumeric) {
                this.textField.addFocusListener(this);
            }
        } else {
            this.initAsLongTextField();
            this.label.setText(param.getTitle());
            if (param.getValue() != null) {
                this.textField.setText(param.getValue().toString());
            }
            if (param instanceof ParamNumeric) {
                this.textField.addFocusListener(this);
            }
        }
    }

    @Override
    public void updateModel() {
        if (this.textField.getText().length() > 0) {
            this.model.setValue(this.textField.getText());
        } else {
            this.model.setValue(null);
        }
    }

    @Override
    public Param getModel() {
        this.updateModel();
        return this.model;
    }

    private void initAsShortTextField() {
        this.removeAll();
        AnchorLayout anchorLayout = new AnchorLayout();
        this.setLayout((LayoutManager)anchorLayout);
        this.setPreferredSize(new Dimension(241, 37));
        this.setMaximumSize(new Dimension(2000, 37));
        int n = 58;
        this.label = new JLabel();
        this.add((Component)this.label, new AnchorConstraint(202, 234, 689, 12, 1, 0, 0, 2));
        if (this.model != null) {
            this.label.setText(this.model.getTitle());
            n = SwingUtilities.computeStringWidth(this.label.getFontMetrics(this.label.getFont()), this.model.getTitle());
        }
        int n2 = Math.max(n + 22, 80);
        this.textField = new JTextField();
        this.add((Component)this.textField, new AnchorConstraint(148, 529, 743, n2, 1, 0, 0, 2));
        this.textField.setPreferredSize(new Dimension(71, 22));
        this.textField.setHorizontalAlignment(0);
    }

    private void initAsLongTextField() {
        this.removeAll();
        AnchorLayout anchorLayout = new AnchorLayout();
        this.setLayout((LayoutManager)anchorLayout);
        this.setPreferredSize(new Dimension(241, 37));
        int n = 58;
        this.label = new JLabel();
        this.add((Component)this.label, new AnchorConstraint(202, 234, 689, 12, 1, 0, 0, 2));
        if (this.model != null) {
            this.label.setText(this.model.getTitle());
            n = SwingUtilities.computeStringWidth(this.label.getFontMetrics(this.label.getFont()), this.model.getTitle());
        }
        int n2 = Math.max(n + 22, 80);
        this.textField = new JTextField();
        this.add((Component)this.textField, new AnchorConstraint(148, 12, 743, n2, 1, 2, 0, 2));
        this.textField.setPreferredSize(new Dimension(161, 22));
        this.textField.setHorizontalAlignment(0);
        this.setPreferredSize(new Dimension(200, 37));
        this.setMaximumSize(new Dimension(2000, 37));
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        JTextField jTextField = (JTextField)focusEvent.getSource();
        String string = jTextField.getText();
        try {
            double d = Double.parseDouble(string);
            ParamNumeric paramNumeric = (ParamNumeric)this.model;
            if (paramNumeric.getLowerBound() != null && d < paramNumeric.getLowerBound()) {
                jTextField.setText(paramNumeric.getLowerBound().toString());
            }
            if (paramNumeric.getUpperBound() != null && d > paramNumeric.getUpperBound()) {
                jTextField.setText(paramNumeric.getUpperBound().toString());
            }
        }
        catch (Exception exception) {
            jTextField.setText("");
        }
    }
}

