/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import umontreal.iro.lecuyer.util.NameConflictException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassFinder
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -4847630831331065792L;
    private List<List<String>> imports = new LinkedList<List<String>>();

    public ClassFinder() {
        ArrayList arrayList = new ArrayList();
        this.imports.add(arrayList);
    }

    public List<String> getImports() {
        return this.imports.get(this.imports.size() - 1);
    }

    public void saveImports() {
        List<String> list = this.getImports();
        ArrayList<String> arrayList = new ArrayList<String>(list);
        this.imports.add(arrayList);
    }

    public void restoreImports() {
        if (this.imports.size() == 1) {
            this.getImports().clear();
        } else {
            this.imports.remove(this.imports.size() - 1);
        }
    }

    public Class<?> findClass(String string) throws ClassNotFoundException, NameConflictException {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            List<String> list = this.getImports();
            Class<?> clazz = null;
            String string2 = "";
            boolean bl = false;
            int n = string.indexOf(46);
            String string3 = n == -1 ? string : string.substring(0, n);
            for (String string4 : list) {
                Class<?> clazz2 = null;
                boolean bl2 = false;
                if (!string4.endsWith(".*")) {
                    if (string4.endsWith("." + string3)) {
                        String string5 = string4.substring(0, string4.length() - string3.length()) + string;
                        try {
                            clazz2 = Class.forName(string5);
                        }
                        catch (ClassNotFoundException classNotFoundException2) {}
                    }
                } else {
                    try {
                        clazz2 = Class.forName(string4.substring(0, string4.length() - 1) + string);
                        bl2 = true;
                    }
                    catch (ClassNotFoundException classNotFoundException3) {
                        // empty catch block
                    }
                }
                if (clazz2 == null) continue;
                if (clazz == null || bl && !bl2) {
                    clazz = clazz2;
                    string2 = string4;
                    bl = bl2;
                    continue;
                }
                if (clazz == clazz2) continue;
                throw new NameConflictException(this, string, "simple class name " + string + " matches " + clazz.getName() + " (import string " + string2 + ") or " + clazz2.getName() + " (import string " + string4 + ")");
            }
            if (clazz == null) {
                throw new ClassNotFoundException("Cannot find the class with name " + string);
            }
            return clazz;
        }
    }

    public String getSimpleName(Class<?> clazz) {
        String string2;
        if (clazz.isArray()) {
            return this.getSimpleName(clazz.getComponentType()) + "[]";
        }
        if (clazz.isPrimitive()) {
            return clazz.getName();
        }
        Class<?> clazz2 = clazz;
        while (clazz2.getDeclaringClass() != null) {
            clazz2 = clazz2.getDeclaringClass();
        }
        boolean bl = true;
        for (String string2 : this.getImports()) {
            String string3;
            if (string2.equals(clazz2.getName())) {
                bl = false;
                continue;
            }
            if (!string2.endsWith(".*") || !(string3 = string2.substring(0, string2.length() - 2)).equals(clazz.getPackage().getName())) continue;
            bl = false;
        }
        if (bl) {
            return clazz.getName();
        }
        String string4 = clazz.getName();
        if (!string4.startsWith(string2 = clazz.getPackage().getName())) {
            throw new IllegalStateException("The class name " + (String)string4 + " does not contain the package name " + string2);
        }
        return string4.substring(string2.length() + 1);
    }

    public ClassFinder clone() {
        ClassFinder classFinder;
        try {
            classFinder = (ClassFinder)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("CloneNotSupported thrown for a class implementing Cloneable");
        }
        classFinder.imports = new LinkedList<List<String>>();
        for (List<String> list : this.imports) {
            ArrayList<String> arrayList = new ArrayList<String>(list);
            classFinder.imports.add(arrayList);
        }
        return classFinder;
    }
}

