/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Fuzzy_Instance_Based_Learning.VWFuzzyKNN;

import java.util.Arrays;
import java.util.StringTokenizer;
import keel.Algorithms.Fuzzy_Instance_Based_Learning.FuzzyIBLAlgorithm;
import keel.Algorithms.Fuzzy_Instance_Based_Learning.ReportTool;
import keel.Algorithms.Fuzzy_Instance_Based_Learning.Timer;
import keel.Algorithms.Fuzzy_Instance_Based_Learning.Util;
import org.core.Files;

public class VWFuzzyKNN
extends FuzzyIBLAlgorithm {
    private int K;
    private int KInit;
    private double[][] membership;
    private double[] std;
    private double[][] referenceMembership;
    private double[][] testMembership;

    @Override
    protected void readParameters(String script) {
        String file = Files.readFile(script);
        StringTokenizer fileLines = new StringTokenizer(file, "\n\r");
        fileLines.nextToken();
        fileLines.nextToken();
        fileLines.nextToken();
        String line = fileLines.nextToken();
        StringTokenizer tokens = new StringTokenizer(line, "=");
        tokens.nextToken();
        this.K = Integer.parseInt(tokens.nextToken().substring(1));
        line = fileLines.nextToken();
        tokens = new StringTokenizer(line, "=");
        tokens.nextToken();
        this.KInit = Integer.parseInt(tokens.nextToken().substring(1));
    }

    public VWFuzzyKNN(String script) {
        this.readDataFiles(script);
        this.name = "VWFuzzyKNN";
        this.membership = new double[this.trainData.length][this.nClasses];
        for (int i = 0; i < this.trainData.length; ++i) {
            Arrays.fill(this.membership[i], -1.0);
        }
        this.std = new double[this.trainData.length];
        this.referenceMembership = new double[this.referenceData.length][this.nClasses];
        this.testMembership = new double[this.testData.length][this.nClasses];
        ReportTool.setOutputFile(this.outFile[2]);
    }

    public void generateModel() {
        Timer.resetTime();
        this.assignMembership();
        Timer.setModelTime();
        System.out.println(this.name + " " + this.relation + " Model " + Timer.getModelTime() + "s");
    }

    private void assignMembership() {
        for (int instance = 0; instance < this.trainData.length; ++instance) {
            int i;
            int[] nearestN = new int[this.KInit];
            double[] minDist = new double[this.KInit];
            for (i = 0; i < this.KInit; ++i) {
                nearestN[i] = 0;
                minDist[i] = Double.MAX_VALUE;
            }
            for (i = 0; i < this.trainData.length; ++i) {
                double dist = Util.euclideanDistance(this.trainData[i], this.trainData[instance]);
                if (i == instance) continue;
                boolean stop = false;
                for (int j = 0; j < this.KInit && !stop; ++j) {
                    if (!(dist < minDist[j])) continue;
                    for (int l = this.KInit - 1; l >= j + 1; --l) {
                        minDist[l] = minDist[l - 1];
                        nearestN[l] = nearestN[l - 1];
                    }
                    minDist[j] = dist;
                    nearestN[j] = i;
                    stop = true;
                }
            }
            int[] selectedClasses = new int[this.nClasses];
            Arrays.fill(selectedClasses, 0);
            for (i = 0; i < this.KInit; ++i) {
                int n = this.trainOutput[nearestN[i]];
                selectedClasses[n] = selectedClasses[n] + 1;
            }
            Arrays.fill(this.membership[instance], 0.0);
            double sum = 0.0;
            double quad = 0.0;
            for (i = 0; i < this.nClasses; ++i) {
                double term;
                this.membership[instance][i] = term = (double)selectedClasses[i] / (double)this.KInit;
                sum += term;
                quad += term * term;
            }
            this.std[instance] = quad / (double)this.KInit - sum / (double)this.KInit * (sum / (double)this.KInit);
            this.std[instance] = Math.sqrt(this.std[instance]);
        }
    }

    public void classifyTrain() {
        Timer.resetTime();
        this.classifyTrainSet();
        Timer.setTrainingTime();
        System.out.println(this.name + " " + this.relation + " Training " + Timer.getTrainingTime() + "s");
    }

    public void classifyTest() {
        Timer.resetTime();
        this.classifyTestSet();
        Timer.setTestTime();
        System.out.println(this.name + " " + this.relation + " Test " + Timer.getTestTime() + "s");
    }

    public void classifyTrainSet() {
        for (int i = 0; i < this.trainData.length; ++i) {
            this.computeTrainMembership(i, this.referenceData[i]);
            this.trainPrediction[i] = this.computeClass(this.referenceMembership[i]);
        }
    }

    public void classifyTestSet() {
        for (int i = 0; i < this.testData.length; ++i) {
            this.computeTestMembership(i, this.testData[i]);
            this.testPrediction[i] = this.computeClass(this.testMembership[i]);
        }
    }

    private int computeClass(double[] pertenence) {
        double max = Double.MIN_VALUE;
        int output = -1;
        for (int i = 0; i < pertenence.length; ++i) {
            if (!(max < pertenence[i])) continue;
            max = pertenence[i];
            output = i;
        }
        return output;
    }

    private void computeTrainMembership(int index, double[] example) {
        int i;
        int i2;
        int[] nearestN = new int[this.K];
        double[] minDist = new double[this.K];
        for (i2 = 0; i2 < this.K; ++i2) {
            nearestN[i2] = 0;
            minDist[i2] = Double.MAX_VALUE;
        }
        for (i2 = 0; i2 < this.trainData.length; ++i2) {
            if (i2 == index) continue;
            double dist = Util.euclideanDistance(this.trainData[i2], example);
            boolean stop = false;
            for (int j = 0; j < this.K && !stop; ++j) {
                if (!(dist < minDist[j])) continue;
                for (int l = this.K - 1; l >= j + 1; --l) {
                    minDist[l] = minDist[l - 1];
                    nearestN[l] = nearestN[l - 1];
                }
                minDist[j] = dist;
                nearestN[j] = i2;
                stop = true;
            }
        }
        double[] norm = new double[this.K];
        double sum = 0.0;
        for (i = 0; i < this.K; ++i) {
            double partial = 0.0;
            for (int j = 0; j < this.inputAtt; ++j) {
                partial += Math.abs(example[j] - this.trainData[nearestN[i]][j]);
            }
            partial /= (double)this.inputAtt;
            partial = 1.0 - partial;
            norm[i] = this.std[nearestN[i]] * partial;
            sum += norm[i];
        }
        for (i = 0; i < this.K; ++i) {
            for (int c = 0; c < this.nClasses; ++c) {
                double[] dArray = this.referenceMembership[index];
                int n = c;
                dArray[n] = dArray[n] + this.membership[nearestN[i]][c] * (norm[i] / sum);
            }
        }
    }

    private void computeTestMembership(int index, double[] example) {
        int i;
        int i2;
        int[] nearestN = new int[this.K];
        double[] minDist = new double[this.K];
        for (i2 = 0; i2 < this.K; ++i2) {
            nearestN[i2] = 0;
            minDist[i2] = Double.MAX_VALUE;
        }
        for (i2 = 0; i2 < this.trainData.length; ++i2) {
            double dist = Util.euclideanDistance(this.trainData[i2], example);
            boolean stop = false;
            for (int j = 0; j < this.K && !stop; ++j) {
                if (!(dist < minDist[j])) continue;
                for (int l = this.K - 1; l >= j + 1; --l) {
                    minDist[l] = minDist[l - 1];
                    nearestN[l] = nearestN[l - 1];
                }
                minDist[j] = dist;
                nearestN[j] = i2;
                stop = true;
            }
        }
        double[] norm = new double[this.K];
        double sum = 0.0;
        for (i = 0; i < this.K; ++i) {
            double partial = 0.0;
            for (int j = 0; j < this.inputAtt; ++j) {
                partial += Math.abs(example[j] - this.trainData[nearestN[i]][j]);
            }
            partial /= (double)this.inputAtt;
            partial = 1.0 - partial;
            norm[i] = this.std[nearestN[i]] * partial;
            sum += norm[i];
        }
        for (i = 0; i < this.K; ++i) {
            for (int c = 0; c < this.nClasses; ++c) {
                double[] dArray = this.testMembership[index];
                int n = c;
                dArray[n] = dArray[n] + this.membership[nearestN[i]][c] * (norm[i] / sum);
            }
        }
    }

    public void printReport() {
        this.writeOutput(this.outFile[0], this.trainOutput, this.trainPrediction);
        this.writeOutput(this.outFile[1], this.testOutput, this.testPrediction);
        ReportTool.setResults(this.trainOutput, this.trainPrediction, this.testOutput, this.testPrediction, this.nClasses);
        ReportTool.printReport();
    }
}

